/**
 * Parameters for the current script
 * @type {
 *     {numberOfTenants : int}
 * }
 */
const conversionsParams = JSON.parse(atob($('#conversions_js').data('params')));

function checkboxCallback(numItemsSelected) {
    if (numItemsSelected === undefined || isNaN(numItemsSelected)) {
        numItemsSelected = 0;
    }
    const selectedIds = getSelectedIds('conversionsTable_select');
    if (numItemsSelected === 0) {
        $('#delete_button_link').addClass("disabled disabled-menu-item");
        $('#duplicate_button_link').addClass("disabled disabled-menu-item");
    } else {
        $('#delete_button_link').removeClass("disabled disabled-menu-item");
        $('#duplicate_button_link').removeClass("disabled disabled-menu-item");
    }
    setHiddenFormTextParameter($('#conversions_delete_form'), selectedIds);
    setHiddenFormTextParameter($('#conversions_duplicate_form'), selectedIds);

    const exportLink = $('#export_link');
    if (numItemsSelected === 0) {
        exportLink.addClass("disabled disabled-menu-item");
        exportLink.removeAttr('href');
    } else {
        exportLink.removeClass("disabled disabled-menu-item");
        exportLink.attr('href', exportLink.data('linktemplate').replace('999', selectedIds));
    }
}

$(document).ready(function () {
    checkboxCallback();
    $('#delete_button_link').click(function () {
        $('#conversions_delete_form').submit();
    });
    $('#duplicate_button_link').click(function () {
        if (conversionsParams.numberOfTenants > 1) {
            $('#conversions_duplicate_modal').modal('show');
        } else {
            $('#conversions_duplicate_form').submit();
        }
    });
});
