/**
 * Parameters for the current script
 * @type {
 *     {modalHtmlID : string},
 *     {createBtfStringUrl : string},
 *     {splitBtfStringUrl : string},
 *     {btfElements : [
 *         {textFieldHtmlID : string},
 *         {buttonHtmlID : string},
 *         {fetchTypeOrPmtTypeName : string}
 *     ]}
 * }
 */
const btfModalJs = $('#btf_modal_js');
const btfModalParams = JSON.parse(atob(btfModalJs.attr('data-params')));

$(document).ready(function () {
    $('a[id^=select_serviceName_link_]').click(function () {
        $('#' + btfModalParams.modalHtmlID + '_serviceName').val($(this).data('servicename'));
    });
    $('a[id^=select_serviceOption_link_]').click(function () {
        $('#' + btfModalParams.modalHtmlID + '_serviceOption').val($(this).data('serviceoption'));
    });
    $('a[id^=select_scope_link_]').click(function () {
        $('#' + btfModalParams.modalHtmlID + '_scope').val($(this).data('scope'));
    });
    $('a[id^=select_message_link_]').click(function () {
        $('#' + btfModalParams.modalHtmlID + '_message').val($(this).data('messagename'));
    });

    $('#' + btfModalParams.modalHtmlID + '_submit').click(function () {
        let isVopBtf = document.getElementById(btfModalParams.modalHtmlID + '_pmtType').value.endsWith('_VOP');
        let ajaxUrl = btfModalParams.createBtfStringUrl.replace('SERVICE_NAME',
            encodeURIComponent(document.getElementById(btfModalParams.modalHtmlID + '_serviceName').value)).replace(
            'SERVICE_OPTION',
            encodeURIComponent(document.getElementById(btfModalParams.modalHtmlID + '_serviceOption').value)).replace(
            'SCOPE',
            encodeURIComponent(document.getElementById(btfModalParams.modalHtmlID + '_scope').value)).replace(
            'CONTAINER',
            encodeURIComponent(document.getElementById(btfModalParams.modalHtmlID + '_containerType').value)).replace(
            'MESSAGE',
            encodeURIComponent(document.getElementById(btfModalParams.modalHtmlID + '_message').value)).replace(
            'VARIANT',
            encodeURIComponent(document.getElementById(btfModalParams.modalHtmlID + '_variant').value)).replace(
            'VERSION',
            encodeURIComponent(document.getElementById(btfModalParams.modalHtmlID + '_version').value)).replace(
            'FORMAT',
            encodeURIComponent(document.getElementById(btfModalParams.modalHtmlID + '_format').value)).replace(
            'EMPTY_ALLOWED',
            encodeURIComponent(isVopBtf));
        $.ajax({
            url: ajaxUrl,
            success: function (result) {
                btfModalParams.btfElements.forEach(function (btfElement) {
                    if (!btfElement.fetchTypeOrPmtTypeName || (btfElement.fetchTypeOrPmtTypeName === document.getElementById(
                        btfModalParams.modalHtmlID + '_pmtType').value)) {
                        $('#' + btfElement.textFieldHtmlID).val(result);
                    }
                });
                $('#' + btfModalParams.modalHtmlID).modal('hide');
            },
            error: function (result) {
                $('#' + btfModalParams.modalHtmlID + '_invalid_btf_string_warning').parent().hide();
                $('#' + btfModalParams.modalHtmlID + '_invalid_input_warning').parent().show();
                if (result.responseText.includes('serviceName')) {
                    $('#' + btfModalParams.modalHtmlID + '_serviceName').addClass('is-invalid');
                } else {
                    $('#' + btfModalParams.modalHtmlID + '_serviceName').removeClass('is-invalid');
                }
                if (result.responseText.includes('serviceOption')) {
                    $('#' + btfModalParams.modalHtmlID + '_serviceOption').addClass('is-invalid');
                } else {
                    $('#' + btfModalParams.modalHtmlID + '_serviceOption').removeClass('is-invalid');
                }
                if (result.responseText.includes('scope')) {
                    $('#' + btfModalParams.modalHtmlID + '_scope').addClass('is-invalid');
                } else {
                    $('#' + btfModalParams.modalHtmlID + '_scope').removeClass('is-invalid');
                }
                if (result.responseText.includes('container')) {
                    $('#' + btfModalParams.modalHtmlID + '_containerType').addClass('is-invalid');
                } else {
                    $('#' + btfModalParams.modalHtmlID + '_containerType').removeClass('is-invalid');
                }
                if (result.responseText.includes('message')) {
                    $('#' + btfModalParams.modalHtmlID + '_message').addClass('is-invalid');
                } else {
                    $('#' + btfModalParams.modalHtmlID + '_message').removeClass('is-invalid');
                }
                if (result.responseText.includes('variant')) {
                    $('#' + btfModalParams.modalHtmlID + '_variant').addClass('is-invalid');
                } else {
                    $('#' + btfModalParams.modalHtmlID + '_variant').removeClass('is-invalid');
                }
                if (result.responseText.includes('version')) {
                    $('#' + btfModalParams.modalHtmlID + '_version').addClass('is-invalid');
                } else {
                    $('#' + btfModalParams.modalHtmlID + '_version').removeClass('is-invalid');
                }
                if (result.responseText.includes('format')) {
                    $('#' + btfModalParams.modalHtmlID + '_format').addClass('is-invalid');
                } else {
                    $('#' + btfModalParams.modalHtmlID + '_format').removeClass('is-invalid');
                }
            }
        });
    });

    $('#' + btfModalParams.modalHtmlID + '_reset').click(function () {
        $('#' + btfModalParams.modalHtmlID + '_invalid_input_warning').parent().hide();
        $('#' + btfModalParams.modalHtmlID + '_invalid_btf_string_warning').parent().hide();
        $('#' + btfModalParams.modalHtmlID + '_serviceName').removeClass('is-invalid');
        $('#' + btfModalParams.modalHtmlID + '_serviceOption').removeClass('is-invalid');
        $('#' + btfModalParams.modalHtmlID + '_scope').removeClass('is-invalid');
        $('#' + btfModalParams.modalHtmlID + '_containerType').removeClass('is-invalid');
        $('#' + btfModalParams.modalHtmlID + '_message').removeClass('is-invalid');
        $('#' + btfModalParams.modalHtmlID + '_variant').removeClass('is-invalid');
        $('#' + btfModalParams.modalHtmlID + '_version').removeClass('is-invalid');
        $('#' + btfModalParams.modalHtmlID + '_format').removeClass('is-invalid');
        let ajaxUrl = btfModalParams.splitBtfStringUrl.replace('BTF_STRING', 'DEFAULT').replace('PMT_TYPE_NAME',
            encodeURIComponent(document.getElementById(btfModalParams.modalHtmlID + '_pmtType').value));
        $.ajax({
            url: ajaxUrl,
            success: function (result) {
                const btfComponents = JSON.parse(result);
                $('#' + btfModalParams.modalHtmlID + '_serviceName').val(btfComponents.serviceName);
                $('#' + btfModalParams.modalHtmlID + '_serviceOption').val(btfComponents.serviceOption);
                $('#' + btfModalParams.modalHtmlID + '_scope').val(btfComponents.scope);
                $('#' + btfModalParams.modalHtmlID + '_containerType').val(btfComponents.container);
                $('#' + btfModalParams.modalHtmlID + '_message').val(btfComponents.message);
                $('#' + btfModalParams.modalHtmlID + '_variant').val(btfComponents.variant);
                $('#' + btfModalParams.modalHtmlID + '_version').val(btfComponents.version);
                $('#' + btfModalParams.modalHtmlID + '_format').val(btfComponents.format);
            },
            error: function (result) {
                try {
                    const btfComponents = JSON.parse(result.responseText);
                    $('#' + btfModalParams.modalHtmlID + '_serviceName').val(btfComponents.serviceName);
                    $('#' + btfModalParams.modalHtmlID + '_serviceOption').val(btfComponents.serviceOption);
                    $('#' + btfModalParams.modalHtmlID + '_scope').val(btfComponents.scope);
                    $('#' + btfModalParams.modalHtmlID + '_containerType').val(btfComponents.container);
                    $('#' + btfModalParams.modalHtmlID + '_message').val(btfComponents.message);
                    $('#' + btfModalParams.modalHtmlID + '_variant').val(btfComponents.variant);
                    $('#' + btfModalParams.modalHtmlID + '_version').val(btfComponents.version);
                    $('#' + btfModalParams.modalHtmlID + '_format').val(btfComponents.format);
                } catch (e) {
                    $('#' + btfModalParams.modalHtmlID + '_invalid_btf_string_warning').parent().show();
                    $('#' + btfModalParams.modalHtmlID + '_serviceName').val('');
                    $('#' + btfModalParams.modalHtmlID + '_serviceOption').val('');
                    $('#' + btfModalParams.modalHtmlID + '_scope').val('');
                    $('#' + btfModalParams.modalHtmlID + '_containerType').val('');
                    $('#' + btfModalParams.modalHtmlID + '_message').val('');
                    $('#' + btfModalParams.modalHtmlID + '_variant').val('');
                    $('#' + btfModalParams.modalHtmlID + '_version').val('');
                    $('#' + btfModalParams.modalHtmlID + '_format').val('');
                }
            }
        });
    });

    btfModalParams.btfElements.forEach(function (btfElement) {
        $('#' + btfElement.buttonHtmlID).click(function () {
            $('#' + btfModalParams.modalHtmlID + '_pmtType').val(btfElement.fetchTypeOrPmtTypeName);
            $('#' + btfModalParams.modalHtmlID + '_invalid_input_warning').parent().hide();
            $('#' + btfModalParams.modalHtmlID + '_invalid_btf_string_warning').parent().hide();
            $('#' + btfModalParams.modalHtmlID + '_serviceName').removeClass('is-invalid');
            $('#' + btfModalParams.modalHtmlID + '_serviceOption').removeClass('is-invalid');
            $('#' + btfModalParams.modalHtmlID + '_scope').removeClass('is-invalid');
            $('#' + btfModalParams.modalHtmlID + '_containerType').removeClass('is-invalid');
            $('#' + btfModalParams.modalHtmlID + '_message').removeClass('is-invalid');
            $('#' + btfModalParams.modalHtmlID + '_variant').removeClass('is-invalid');
            $('#' + btfModalParams.modalHtmlID + '_version').removeClass('is-invalid');
            $('#' + btfModalParams.modalHtmlID + '_format').removeClass('is-invalid');
            let ajaxUrl = btfModalParams.splitBtfStringUrl.replace('BTF_STRING', encodeURIComponent(document.getElementById(
                btfElement.textFieldHtmlID).value)).replace('PMT_TYPE_NAME', encodeURIComponent(btfElement.fetchTypeOrPmtTypeName));
            $.ajax({
                url: ajaxUrl,
                success: function (result) {
                    const btfComponents = JSON.parse(result);
                    $('#' + btfModalParams.modalHtmlID + '_serviceName').val(btfComponents.serviceName);
                    $('#' + btfModalParams.modalHtmlID + '_serviceOption').val(btfComponents.serviceOption);
                    $('#' + btfModalParams.modalHtmlID + '_scope').val(btfComponents.scope);
                    $('#' + btfModalParams.modalHtmlID + '_containerType').val(btfComponents.container);
                    $('#' + btfModalParams.modalHtmlID + '_message').val(btfComponents.message);
                    $('#' + btfModalParams.modalHtmlID + '_variant').val(btfComponents.variant);
                    $('#' + btfModalParams.modalHtmlID + '_version').val(btfComponents.version);
                    $('#' + btfModalParams.modalHtmlID + '_format').val(btfComponents.format);
                },
                error: function (result) {
                    $('#' + btfModalParams.modalHtmlID + '_invalid_btf_string_warning').parent().show();
                    try {
                        const btfComponents = JSON.parse(result.responseText);
                        $('#' + btfModalParams.modalHtmlID + '_serviceName').val(btfComponents.serviceName);
                        $('#' + btfModalParams.modalHtmlID + '_serviceOption').val(btfComponents.serviceOption);
                        $('#' + btfModalParams.modalHtmlID + '_scope').val(btfComponents.scope);
                        $('#' + btfModalParams.modalHtmlID + '_containerType').val(btfComponents.container);
                        $('#' + btfModalParams.modalHtmlID + '_message').val(btfComponents.message);
                        $('#' + btfModalParams.modalHtmlID + '_variant').val(btfComponents.variant);
                        $('#' + btfModalParams.modalHtmlID + '_version').val(btfComponents.version);
                        $('#' + btfModalParams.modalHtmlID + '_format').val(btfComponents.format);
                    } catch (e) {
                        $('#' + btfModalParams.modalHtmlID + '_serviceName').val('');
                        $('#' + btfModalParams.modalHtmlID + '_serviceOption').val('');
                        $('#' + btfModalParams.modalHtmlID + '_scope').val('');
                        $('#' + btfModalParams.modalHtmlID + '_containerType').val('');
                        $('#' + btfModalParams.modalHtmlID + '_message').val('');
                        $('#' + btfModalParams.modalHtmlID + '_variant').val('');
                        $('#' + btfModalParams.modalHtmlID + '_version').val('');
                        $('#' + btfModalParams.modalHtmlID + '_format').val('');
                    }
                }
            });
        });
    });
})


