/**
 * Parameters for the current script
 * @type {
 *     {hasFormCompanyErrors : Boolean},
 *     {companies : [
 *         {id : number},
 *         {tenantId : number},
 *         {number : String},
 *         {name : String},
 *         {street : String},
 *         {postbox : String},
 *         {postcode : String},
 *         {town : String},
 *         {country : String}
 *     ]}
 * }
 */
const awvparticipantform_js = JSON.parse(atob($('#awvparticipantform_js').data('params')));

function deleteCompany() {
    const companiesToDeleteField = $('input[name=companiesToDelete]');
    const id = $('#companyId').val();
    if (id != null && id !== '') {
        let toDelete = companiesToDeleteField.val();
        if (toDelete == null || toDelete === '') {
            toDelete = '';
        } else {
            toDelete += ',';
        }
        toDelete += id;
        companiesToDeleteField.val(toDelete);
        $('#companyId option[value="' + id + '"]').remove();
    }
    $('#awv_participant_delete_company_modal').modal('hide');
    companyIdChanged();
}


function companyIdChanged() {
    const id = parseInt($('#companyId').val());
    const deleteButton = $('#awv_participant_delete_company_button');
    const deleteButton2 = $('#delete_company_button');
    if (id === -1) {
        $('#companyNumber').val('');
        $('#companyName').val('');
        $('#companyStreet').val('');
        $('#companyPostbox').val('');
        $('#companyPostcode').val('');
        $('#companyTown').val('');
        $('#companyCountry').val('');
        $('#awv_participant_company_details_collapse').collapse('show');
        deleteButton.addClass('disabled');
        deleteButton2.addClass('disabled');
        deleteButton.attr('data-toggle', '');
    } else if (awvparticipantform_js.companies != null) {
        awvparticipantform_js.companies.forEach(function (company) {
            if (company.id !== id) {
                return;
            }
            if (company.tenantId != null) {
                $('#companyTenantId').val(company.tenantId);
            }
            $('#companyNumber').val(company.number);
            $('#companyName').val(company.name);
            $('#companyStreet').val(company.street);
            $('#companyPostbox').val(company.postbox);
            $('#companyPostcode').val(company.postcode);
            $('#companyTown').val(company.town);
            $('#companyCountry').val(company.country);
        });
        deleteButton.removeClass('disabled');
        deleteButton.attr('data-toggle', 'modal');
        deleteButton2.removeClass('disabled');
    }
}

$(document).ready(function () {
    if (awvparticipantform_js.hasFormCompanyErrors) {
        $('#awv_participant_company_details_collapse').collapse('show');
    }
    const toDelete = $('#companiesToDelete').val();
    if (toDelete != null && toDelete !== '') {
        toDelete.split(',').forEach(function (id) {
            $('#company option[value="' + id + '"]').remove();
        });
    }
    $('#awv_participant_delete_company_button').click(deleteCompany);
    $('#companyId').change(companyIdChanged);

    const id = parseInt($('#companyId').val());
    if (id === -1) {
        const deleteButton = $('#awv_participant_delete_company_button');
        const deleteButton2 = $('#delete_company_button');
        deleteButton.addClass('disabled');
        deleteButton2.addClass('disabled');
        deleteButton.attr('data-toggle', '');
    }
});