/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.CoordinatedShutdown$;
import play.api.Application;
import play.api.ApplicationLoader;
import play.api.ApplicationLoader$;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Mode;
import play.api.Play$;
import play.core.server.RealServerProcess;
import play.core.server.ReloadableServer;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerProcess;
import play.core.server.ServerProvider;
import play.core.server.ServerProvider$;
import play.core.server.ServerStartException;
import play.core.server.ServerStartException$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ProdServerStart$ {
    public static final ProdServerStart$ MODULE$ = new ProdServerStart$();

    public void main(String[] args) {
        this.start(new RealServerProcess((Seq<String>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])args))));
    }

    public ReloadableServer start(ServerProcess process) {
        Server server;
        try {
            ServerConfig config = this.readServerConfigSettings(process);
            Option<File> pidFile = this.createPidFile(process, config.configuration());
            try {
                Environment environment = new Environment(config.rootDir(), process.classLoader(), (Mode)Mode.Prod$.MODULE$);
                ApplicationLoader.Context context = ApplicationLoader.Context$.MODULE$.create(environment, ApplicationLoader.Context$.MODULE$.create$default$2(), ApplicationLoader.Context$.MODULE$.create$default$3(), ApplicationLoader.Context$.MODULE$.create$default$4());
                ApplicationLoader loader = ApplicationLoader$.MODULE$.apply(context);
                Application application = loader.load(context);
                Play$.MODULE$.start(application);
                ServerProvider serverProvider = ServerProvider$.MODULE$.fromConfiguration(process.classLoader(), config.configuration());
                Server server2 = serverProvider.createServer(config, application);
                String phase = CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate();
                application.coordinatedShutdown().addTask(phase, "remove-pid-file", (Function0 & Serializable)() -> {
                    pidFile.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.delete()));
                    Predef$.MODULE$.assert(pidFile.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ProdServerStart$.$anonfun$start$3(x$2))), (Function0 & Serializable)() -> "PID file should not exist!");
                    return Future$.MODULE$.successful((Object)Done$.MODULE$);
                });
                process.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    if (application.coordinatedShutdown().shutdownReason().isEmpty()) {
                        server2.stop();
                        return;
                    }
                });
                server = server2;
            }
            catch (Throwable e) {
                pidFile.foreach((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.delete()));
                throw e;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ServerStartException) {
                ServerStartException serverStartException = (ServerStartException)throwable2;
                String message = serverStartException.message();
                Option<Throwable> cause = serverStartException.cause();
                throw process.exit(message, cause, process.exit$default$3());
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw process.exit("Oops, cannot start the server.", (Option<Throwable>)new Some((Object)throwable3), process.exit$default$3());
            }
            throw throwable;
        }
        return server;
    }

    public ServerConfig readServerConfigSettings(ServerProcess process) {
        Option rootDirArg = process.args().headOption().map((Function1 & Serializable)x$4 -> new File((String)x$4));
        Map rootDirConfig = (Map)rootDirArg.fold((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty(), (Function1 & Serializable)x$5 -> ServerConfig$.MODULE$.rootDirConfig((File)x$5));
        Configuration configuration = Configuration$.MODULE$.load(process.classLoader(), process.properties(), rootDirConfig, true);
        String path = (String)configuration.getOptional("play.server.dir", ConfigLoader$.MODULE$.stringLoader()).getOrElse((Function0 & Serializable)() -> {
            throw new ServerStartException("No root server path supplied", ServerStartException$.MODULE$.apply$default$2());
        });
        File file = new File(path);
        if (!file.isDirectory()) {
            throw new ServerStartException("Bad root server path: " + path, ServerStartException$.MODULE$.apply$default$2());
        }
        File rootDir = file;
        Option httpPort = ProdServerStart$.parsePort$1("http", configuration);
        Option httpsPort = ProdServerStart$.parsePort$1("https", configuration);
        String address = (String)configuration.getOptional("play.server.http.address", ConfigLoader$.MODULE$.stringLoader()).getOrElse((Function0 & Serializable)() -> "0.0.0.0");
        if (httpPort.orElse((Function0 & Serializable)() -> httpsPort).isEmpty()) {
            throw new ServerStartException("Must provide either an HTTP or HTTPS port", ServerStartException$.MODULE$.apply$default$2());
        }
        return new ServerConfig(rootDir, (Option<Object>)httpPort, (Option<Object>)httpsPort, address, (Mode)Mode.Prod$.MODULE$, process.properties(), configuration);
    }

    public Option<File> createPidFile(ServerProcess process, Configuration configuration) {
        OutputStream outputStream;
        String pidFilePath;
        String string = pidFilePath = (String)configuration.getOptional("play.server.pidfile.path", ConfigLoader$.MODULE$.stringLoader()).getOrElse((Function0 & Serializable)() -> {
            throw new ServerStartException("Pid file path not configured", ServerStartException$.MODULE$.apply$default$2());
        });
        String string2 = "/dev/null";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return None$.MODULE$;
        }
        File pidFile = new File(pidFilePath).getAbsoluteFile();
        String pid = (String)process.pid().getOrElse((Function0 & Serializable)() -> {
            throw new ServerStartException("Couldn't determine current process's pid", ServerStartException$.MODULE$.apply$default$2());
        });
        try {
            outputStream = Files.newOutputStream(pidFile.toPath(), StandardOpenOption.CREATE_NEW);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw new ServerStartException("This application is already running (or delete " + pidFile.getPath() + " file).", ServerStartException$.MODULE$.apply$default$2());
        }
        try (OutputStream out = outputStream;){
            out.write(pid.getBytes());
        }
        return new Some((Object)pidFile);
    }

    public static final /* synthetic */ boolean $anonfun$start$3(File x$2) {
        return !x$2.exists();
    }

    public static final /* synthetic */ boolean $anonfun$readServerConfigSettings$5(String x$6) {
        String string = x$6;
        String string2 = "disabled";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ int $anonfun$readServerConfigSettings$6(String portType$1, String str) {
        int n;
        try {
            n = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServerStartException("Invalid " + portType$1.toUpperCase() + " port: " + str, ServerStartException$.MODULE$.apply$default$2());
        }
        return n;
    }

    private static final Option parsePort$1(String portType, Configuration configuration$1) {
        return configuration$1.getOptional("play.server." + portType + ".port", ConfigLoader$.MODULE$.stringLoader()).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ProdServerStart$.$anonfun$readServerConfigSettings$5(x$6))).map((Function1 & Serializable)str -> BoxesRunTime.boxToInteger((int)ProdServerStart$.$anonfun$readServerConfigSettings$6(portType, str)));
    }

    private ProdServerStart$() {
    }
}

