/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pkcs;

import de.businesslogics.bouncycastle.asn1.ASN1BitString;
import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1Set;
import de.businesslogics.bouncycastle.asn1.DERBitString;
import de.businesslogics.bouncycastle.asn1.DERSet;
import de.businesslogics.bouncycastle.asn1.pkcs.Attribute;
import de.businesslogics.bouncycastle.asn1.pkcs.CertificationRequest;
import de.businesslogics.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import de.businesslogics.bouncycastle.asn1.x500.X500Name;
import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.operator.ContentSigner;
import de.businesslogics.bouncycastle.pkcs.PKCS10CertificationRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PKCS10CertificationRequestBuilder {
    private SubjectPublicKeyInfo publicKeyInfo;
    private X500Name subject;
    private List attributes = new ArrayList();
    private boolean leaveOffEmpty = false;

    public PKCS10CertificationRequestBuilder(X500Name x500Name, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.subject = x500Name;
        this.publicKeyInfo = subjectPublicKeyInfo;
    }

    public PKCS10CertificationRequest build(ContentSigner contentSigner) {
        Object object;
        CertificationRequestInfo certificationRequestInfo;
        if (this.attributes.isEmpty()) {
            certificationRequestInfo = this.leaveOffEmpty ? new CertificationRequestInfo(this.subject, this.publicKeyInfo, null) : new CertificationRequestInfo(this.subject, this.publicKeyInfo, (ASN1Set)new DERSet());
        } else {
            object = new ASN1EncodableVector();
            Iterator iterator = this.attributes.iterator();
            while (iterator.hasNext()) {
                object.add((ASN1Encodable)Attribute.getInstance(iterator.next()));
            }
            certificationRequestInfo = new CertificationRequestInfo(this.subject, this.publicKeyInfo, (ASN1Set)new DERSet((ASN1EncodableVector)object));
        }
        try {
            object = contentSigner.getOutputStream();
            ((OutputStream)object).write(certificationRequestInfo.getEncoded("DER"));
            ((OutputStream)object).close();
            return new PKCS10CertificationRequest(new CertificationRequest(certificationRequestInfo, contentSigner.getAlgorithmIdentifier(), (ASN1BitString)new DERBitString(contentSigner.getSignature())));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certification request signature");
        }
    }
}

