/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.operator.jcajce;

import de.businesslogics.bouncycastle.asn1.ASN1Integer;
import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import de.businesslogics.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.x509.AlgorithmIdentifier;
import de.businesslogics.bouncycastle.jcajce.util.JcaJceHelper;
import de.businesslogics.bouncycastle.jcajce.util.MessageDigestUtils;
import de.businesslogics.bouncycastle.operator.DefaultSignatureNameFinder;
import de.businesslogics.bouncycastle.util.Integers;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.spec.PSSParameterSpec;
import java.util.HashMap;
import java.util.Map;

class OperatorHelper {
    private static final Map oids = new HashMap();
    private static final Map asymmetricWrapperAlgNames = new HashMap();
    private static final Map symmetricWrapperAlgNames = new HashMap();
    private static final Map symmetricKeyAlgNames = new HashMap();
    private static final Map symmetricWrapperKeySizes = new HashMap();
    private static DefaultSignatureNameFinder sigFinder = new DefaultSignatureNameFinder();
    private JcaJceHelper helper;

    OperatorHelper(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    MessageDigest createDigest(AlgorithmIdentifier algorithmIdentifier) throws GeneralSecurityException {
        MessageDigest messageDigest;
        try {
            messageDigest = algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)NISTObjectIdentifiers.id_shake256_len) ? this.helper.createMessageDigest("SHAKE256-" + ASN1Integer.getInstance((Object)algorithmIdentifier.getParameters()).getValue()) : (algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)NISTObjectIdentifiers.id_shake128_len) ? this.helper.createMessageDigest("SHAKE128-" + ASN1Integer.getInstance((Object)algorithmIdentifier.getParameters()).getValue()) : this.helper.createMessageDigest(MessageDigestUtils.getDigestName((ASN1ObjectIdentifier)algorithmIdentifier.getAlgorithm())));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (oids.get(algorithmIdentifier.getAlgorithm()) != null) {
                String string = (String)oids.get(algorithmIdentifier.getAlgorithm());
                messageDigest = this.helper.createMessageDigest(string);
            }
            throw noSuchAlgorithmException;
        }
        return messageDigest;
    }

    Signature createSignature(AlgorithmIdentifier algorithmIdentifier) throws GeneralSecurityException {
        ASN1Sequence aSN1Sequence;
        Object object;
        Signature signature;
        String string = OperatorHelper.getSignatureName(algorithmIdentifier);
        try {
            signature = this.helper.createSignature(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (string.endsWith("WITHRSAANDMGF1")) {
                object = string.substring(0, string.indexOf(87)) + "WITHRSASSA-PSS";
                signature = this.helper.createSignature((String)object);
            }
            throw noSuchAlgorithmException;
        }
        if (algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSASSA_PSS) && this.notDefaultPSSParams(aSN1Sequence = ASN1Sequence.getInstance((Object)algorithmIdentifier.getParameters()))) {
            try {
                object = this.helper.createAlgorithmParameters("PSS");
                ((AlgorithmParameters)object).init(aSN1Sequence.getEncoded());
                signature.setParameter(((AlgorithmParameters)object).getParameterSpec(PSSParameterSpec.class));
            }
            catch (IOException iOException) {
                throw new GeneralSecurityException("unable to process PSS parameters: " + iOException.getMessage());
            }
        }
        return signature;
    }

    private static String getSignatureName(AlgorithmIdentifier algorithmIdentifier) {
        return sigFinder.getAlgorithmName(algorithmIdentifier);
    }

    private boolean notDefaultPSSParams(ASN1Sequence aSN1Sequence) throws GeneralSecurityException {
        if (aSN1Sequence == null || aSN1Sequence.size() == 0) {
            return false;
        }
        RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance((Object)aSN1Sequence);
        if (!rSASSAPSSparams.getMaskGenAlgorithm().getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.id_mgf1)) {
            return true;
        }
        if (!rSASSAPSSparams.getHashAlgorithm().equals((Object)AlgorithmIdentifier.getInstance((Object)rSASSAPSSparams.getMaskGenAlgorithm().getParameters()))) {
            return true;
        }
        MessageDigest messageDigest = this.createDigest(rSASSAPSSparams.getHashAlgorithm());
        return rSASSAPSSparams.getSaltLength().intValue() != messageDigest.getDigestLength();
    }

    static {
        oids.put(OIWObjectIdentifiers.idSHA1, "SHA1");
        oids.put(NISTObjectIdentifiers.id_sha224, "SHA224");
        oids.put(NISTObjectIdentifiers.id_sha256, "SHA256");
        oids.put(NISTObjectIdentifiers.id_sha384, "SHA384");
        oids.put(NISTObjectIdentifiers.id_sha512, "SHA512");
        oids.put(TeleTrusTObjectIdentifiers.ripemd128, "RIPEMD128");
        oids.put(TeleTrusTObjectIdentifiers.ripemd160, "RIPEMD160");
        oids.put(TeleTrusTObjectIdentifiers.ripemd256, "RIPEMD256");
        asymmetricWrapperAlgNames.put(PKCSObjectIdentifiers.rsaEncryption, "RSA/ECB/PKCS1Padding");
        asymmetricWrapperAlgNames.put(OIWObjectIdentifiers.elGamalAlgorithm, "Elgamal/ECB/PKCS1Padding");
        asymmetricWrapperAlgNames.put(PKCSObjectIdentifiers.id_RSAES_OAEP, "RSA/ECB/OAEPPadding");
        asymmetricWrapperAlgNames.put(CryptoProObjectIdentifiers.gostR3410_2001, "ECGOST3410");
        symmetricWrapperAlgNames.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap, "DESEDEWrap");
        symmetricWrapperAlgNames.put(PKCSObjectIdentifiers.id_alg_CMSRC2wrap, "RC2Wrap");
        symmetricWrapperAlgNames.put(NISTObjectIdentifiers.id_aes128_wrap, "AESWrap");
        symmetricWrapperAlgNames.put(NISTObjectIdentifiers.id_aes192_wrap, "AESWrap");
        symmetricWrapperAlgNames.put(NISTObjectIdentifiers.id_aes256_wrap, "AESWrap");
        symmetricWrapperAlgNames.put(NTTObjectIdentifiers.id_camellia128_wrap, "CamelliaWrap");
        symmetricWrapperAlgNames.put(NTTObjectIdentifiers.id_camellia192_wrap, "CamelliaWrap");
        symmetricWrapperAlgNames.put(NTTObjectIdentifiers.id_camellia256_wrap, "CamelliaWrap");
        symmetricWrapperAlgNames.put(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, "SEEDWrap");
        symmetricWrapperAlgNames.put(PKCSObjectIdentifiers.des_EDE3_CBC, "DESede");
        symmetricWrapperKeySizes.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap, Integers.valueOf((int)192));
        symmetricWrapperKeySizes.put(NISTObjectIdentifiers.id_aes128_wrap, Integers.valueOf((int)128));
        symmetricWrapperKeySizes.put(NISTObjectIdentifiers.id_aes192_wrap, Integers.valueOf((int)192));
        symmetricWrapperKeySizes.put(NISTObjectIdentifiers.id_aes256_wrap, Integers.valueOf((int)256));
        symmetricWrapperKeySizes.put(NTTObjectIdentifiers.id_camellia128_wrap, Integers.valueOf((int)128));
        symmetricWrapperKeySizes.put(NTTObjectIdentifiers.id_camellia192_wrap, Integers.valueOf((int)192));
        symmetricWrapperKeySizes.put(NTTObjectIdentifiers.id_camellia256_wrap, Integers.valueOf((int)256));
        symmetricWrapperKeySizes.put(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, Integers.valueOf((int)128));
        symmetricWrapperKeySizes.put(PKCSObjectIdentifiers.des_EDE3_CBC, Integers.valueOf((int)192));
        symmetricKeyAlgNames.put(NISTObjectIdentifiers.aes, "AES");
        symmetricKeyAlgNames.put(NISTObjectIdentifiers.id_aes128_CBC, "AES");
        symmetricKeyAlgNames.put(NISTObjectIdentifiers.id_aes192_CBC, "AES");
        symmetricKeyAlgNames.put(NISTObjectIdentifiers.id_aes256_CBC, "AES");
        symmetricKeyAlgNames.put(PKCSObjectIdentifiers.des_EDE3_CBC, "DESede");
        symmetricKeyAlgNames.put(PKCSObjectIdentifiers.RC2_CBC, "RC2");
    }
}

