/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.operator.jcajce;

import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.DERBitString;
import de.businesslogics.bouncycastle.asn1.DERSequence;
import de.businesslogics.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import de.businesslogics.bouncycastle.asn1.x509.AlgorithmIdentifier;
import de.businesslogics.bouncycastle.jcajce.CompositePrivateKey;
import de.businesslogics.bouncycastle.jcajce.io.OutputStreamFactory;
import de.businesslogics.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import de.businesslogics.bouncycastle.jcajce.util.JcaJceHelper;
import de.businesslogics.bouncycastle.operator.ContentSigner;
import de.businesslogics.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import de.businesslogics.bouncycastle.operator.OperatorCreationException;
import de.businesslogics.bouncycastle.operator.RuntimeOperatorException;
import de.businesslogics.bouncycastle.operator.jcajce.OperatorHelper;
import de.businesslogics.bouncycastle.util.Strings;
import de.businesslogics.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JcaContentSignerBuilder {
    private static final Set isAlgIdFromPrivate = new HashSet();
    private final String signatureAlgorithm;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmParameterSpec sigAlgSpec;

    public JcaContentSignerBuilder(String string) {
        this.signatureAlgorithm = string;
    }

    public ContentSigner build(PrivateKey privateKey) throws OperatorCreationException {
        if (privateKey instanceof CompositePrivateKey && ((CompositePrivateKey)privateKey).getAlgorithmIdentifier().equals((ASN1Primitive)MiscObjectIdentifiers.id_composite_key)) {
            return this.buildComposite((CompositePrivateKey)privateKey);
        }
        try {
            if (this.sigAlgSpec == null) {
                if (isAlgIdFromPrivate.contains(Strings.toUpperCase((String)this.signatureAlgorithm))) {
                    this.sigAlgId = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()).getPrivateKeyAlgorithm();
                    this.sigAlgSpec = null;
                } else {
                    this.sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(this.signatureAlgorithm);
                    this.sigAlgSpec = null;
                }
            }
            final AlgorithmIdentifier algorithmIdentifier = this.sigAlgId;
            final Signature signature = this.helper.createSignature(this.sigAlgId);
            if (this.random != null) {
                signature.initSign(privateKey, this.random);
            } else {
                signature.initSign(privateKey);
            }
            return new ContentSigner(){
                private OutputStream stream;
                {
                    this.stream = OutputStreamFactory.createStream((Signature)signature);
                }

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return algorithmIdentifier;
                }

                public OutputStream getOutputStream() {
                    return this.stream;
                }

                public byte[] getSignature() {
                    try {
                        return signature.sign();
                    }
                    catch (SignatureException signatureException) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("cannot create signer: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private ContentSigner buildComposite(CompositePrivateKey compositePrivateKey) throws OperatorCreationException {
        try {
            List list = compositePrivateKey.getPrivateKeys();
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)this.sigAlgId.getParameters());
            final Signature[] signatureArray = new Signature[aSN1Sequence.size()];
            for (int i = 0; i != aSN1Sequence.size(); ++i) {
                signatureArray[i] = this.helper.createSignature(AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(i)));
                if (this.random != null) {
                    signatureArray[i].initSign((PrivateKey)list.get(i), this.random);
                    continue;
                }
                signatureArray[i].initSign((PrivateKey)list.get(i));
            }
            OutputStream outputStream = OutputStreamFactory.createStream((Signature)signatureArray[0]);
            for (int i = 1; i != signatureArray.length; ++i) {
                outputStream = new TeeOutputStream(outputStream, OutputStreamFactory.createStream((Signature)signatureArray[i]));
            }
            final OutputStream outputStream2 = outputStream;
            return new ContentSigner(){
                OutputStream stream;
                {
                    this.stream = outputStream2;
                }

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return JcaContentSignerBuilder.this.sigAlgId;
                }

                public OutputStream getOutputStream() {
                    return this.stream;
                }

                public byte[] getSignature() {
                    try {
                        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                        for (int i = 0; i != signatureArray.length; ++i) {
                            aSN1EncodableVector.add((ASN1Encodable)new DERBitString(signatureArray[i].sign()));
                        }
                        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
                    }
                    catch (IOException iOException) {
                        throw new RuntimeOperatorException("exception encoding signature: " + iOException.getMessage(), iOException);
                    }
                    catch (SignatureException signatureException) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("cannot create signer: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    static {
        isAlgIdFromPrivate.add("DILITHIUM");
        isAlgIdFromPrivate.add("SPHINCS+");
        isAlgIdFromPrivate.add("SPHINCSPlus");
    }
}

