/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.openssl.jcajce;

import de.businesslogics.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import de.businesslogics.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import de.businesslogics.bouncycastle.openssl.MiscPEMGenerator;
import de.businesslogics.bouncycastle.openssl.PEMEncryptor;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class JcaMiscPEMGenerator
extends MiscPEMGenerator {
    public JcaMiscPEMGenerator(Object object, PEMEncryptor pEMEncryptor) throws IOException {
        super(JcaMiscPEMGenerator.convertObject(object), pEMEncryptor);
    }

    private static Object convertObject(Object object) throws IOException {
        if (object instanceof X509Certificate) {
            try {
                return new JcaX509CertificateHolder((X509Certificate)object);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IllegalArgumentException("Cannot encode object: " + certificateEncodingException.toString());
            }
        }
        if (object instanceof X509CRL) {
            try {
                return new JcaX509CRLHolder((X509CRL)object);
            }
            catch (CRLException cRLException) {
                throw new IllegalArgumentException("Cannot encode object: " + cRLException.toString());
            }
        }
        if (object instanceof KeyPair) {
            return JcaMiscPEMGenerator.convertObject(((KeyPair)object).getPrivate());
        }
        if (object instanceof PrivateKey) {
            return PrivateKeyInfo.getInstance((Object)((Key)object).getEncoded());
        }
        if (object instanceof PublicKey) {
            return SubjectPublicKeyInfo.getInstance((Object)((PublicKey)object).getEncoded());
        }
        return object;
    }
}

