/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.openssl;

import de.businesslogics.bouncycastle.asn1.ASN1InputStream;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.cert.X509CertificateHolder;
import de.businesslogics.bouncycastle.openssl.CertificateTrustBlock;
import de.businesslogics.bouncycastle.util.Arrays;
import java.io.IOException;

public class X509TrustedCertificateBlock {
    private final X509CertificateHolder certificateHolder;
    private final CertificateTrustBlock trustBlock;

    public X509TrustedCertificateBlock(byte[] byArray) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        this.certificateHolder = new X509CertificateHolder(aSN1InputStream.readObject().getEncoded());
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        this.trustBlock = aSN1Primitive != null ? new CertificateTrustBlock(aSN1Primitive.getEncoded()) : null;
    }

    public byte[] getEncoded() throws IOException {
        return Arrays.concatenate((byte[])this.certificateHolder.getEncoded(), (byte[])this.trustBlock.toASN1Sequence().getEncoded());
    }
}

