/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.openssl;

import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.ASN1TaggedObject;
import de.businesslogics.bouncycastle.asn1.ASN1UTF8String;
import de.businesslogics.bouncycastle.asn1.DERSequence;
import de.businesslogics.bouncycastle.asn1.DERTaggedObject;
import de.businesslogics.bouncycastle.asn1.DERUTF8String;
import java.util.Enumeration;

public class CertificateTrustBlock {
    private ASN1Sequence uses;
    private ASN1Sequence prohibitions;
    private String alias;

    CertificateTrustBlock(byte[] byArray) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)byArray);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
            if (aSN1Encodable instanceof ASN1Sequence) {
                this.uses = ASN1Sequence.getInstance((Object)aSN1Encodable);
                continue;
            }
            if (aSN1Encodable instanceof ASN1TaggedObject) {
                this.prohibitions = ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable), (boolean)false);
                continue;
            }
            if (!(aSN1Encodable instanceof ASN1UTF8String)) continue;
            this.alias = ASN1UTF8String.getInstance((Object)aSN1Encodable).getString();
        }
    }

    ASN1Sequence toASN1Sequence() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.uses != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.uses);
        }
        if (this.prohibitions != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.prohibitions));
        }
        if (this.alias != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERUTF8String(this.alias));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

