/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.cert.bc;

import de.businesslogics.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import de.businesslogics.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import de.businesslogics.bouncycastle.cert.X509ExtensionUtils;
import de.businesslogics.bouncycastle.crypto.digests.SHA1Digest;
import de.businesslogics.bouncycastle.crypto.params.AsymmetricKeyParameter;
import de.businesslogics.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import de.businesslogics.bouncycastle.operator.DigestCalculator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BcX509ExtensionUtils
extends X509ExtensionUtils {
    public BcX509ExtensionUtils() {
        super(new SHA1DigestCalculator());
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        return super.createAuthorityKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)asymmetricKeyParameter));
    }

    public SubjectKeyIdentifier createSubjectKeyIdentifier(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        return super.createSubjectKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)asymmetricKeyParameter));
    }

    private static class SHA1DigestCalculator
    implements DigestCalculator {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private SHA1DigestCalculator() {
        }

        public OutputStream getOutputStream() {
            return this.bOut;
        }

        public byte[] getDigest() {
            byte[] byArray = this.bOut.toByteArray();
            this.bOut.reset();
            SHA1Digest sHA1Digest = new SHA1Digest();
            sHA1Digest.update(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
            sHA1Digest.doFinal(byArray2, 0);
            return byArray2;
        }
    }
}

