/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.cert;

import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1Integer;
import de.businesslogics.bouncycastle.asn1.ASN1Object;
import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.asn1.DERBitString;
import de.businesslogics.bouncycastle.asn1.DERSequence;
import de.businesslogics.bouncycastle.asn1.x500.X500Name;
import de.businesslogics.bouncycastle.asn1.x509.AlgorithmIdentifier;
import de.businesslogics.bouncycastle.asn1.x509.Certificate;
import de.businesslogics.bouncycastle.asn1.x509.DeltaCertificateDescriptor;
import de.businesslogics.bouncycastle.asn1.x509.Extension;
import de.businesslogics.bouncycastle.asn1.x509.ExtensionsGenerator;
import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.asn1.x509.TBSCertificate;
import de.businesslogics.bouncycastle.asn1.x509.Time;
import de.businesslogics.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import de.businesslogics.bouncycastle.cert.CertIOException;
import de.businesslogics.bouncycastle.cert.X509CertificateHolder;
import de.businesslogics.bouncycastle.operator.ContentSigner;
import de.businesslogics.bouncycastle.util.Exceptions;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;

public class X509v3CertificateBuilder {
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private ExtensionsGenerator extGenerator;

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Date date, Date date2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(x500Name, bigInteger, new Time(date), new Time(date2), x500Name2, subjectPublicKeyInfo);
    }

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Time time, Time time2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.tbsGen.setSerialNumber(new ASN1Integer(bigInteger));
        this.tbsGen.setIssuer(x500Name);
        this.tbsGen.setStartDate(time);
        this.tbsGen.setEndDate(time2);
        this.tbsGen.setSubject(x500Name2);
        this.tbsGen.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        this.extGenerator = new ExtensionsGenerator();
    }

    public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1Encodable aSN1Encodable) throws CertIOException {
        try {
            this.extGenerator.addExtension(aSN1ObjectIdentifier, bl, aSN1Encodable);
        }
        catch (IOException iOException) {
            throw new CertIOException("cannot encode extension: " + iOException.getMessage(), iOException);
        }
        return this;
    }

    public X509CertificateHolder build(ContentSigner contentSigner) {
        TBSCertificate tBSCertificate;
        this.tbsGen.setSignature(contentSigner.getAlgorithmIdentifier());
        if (!this.extGenerator.isEmpty()) {
            if (this.extGenerator.hasExtension(Extension.deltaCertificateDescriptor)) {
                tBSCertificate = this.extGenerator.getExtension(Extension.deltaCertificateDescriptor);
                DeltaCertificateDescriptor deltaCertificateDescriptor = DeltaCertificateDescriptor.getInstance((Object)tBSCertificate.getParsedValue());
                try {
                    this.extGenerator.replaceExtension(Extension.deltaCertificateDescriptor, tBSCertificate.isCritical(), (ASN1Encodable)deltaCertificateDescriptor.trimTo(this.tbsGen.generateTBSCertificate(), this.extGenerator.generate()));
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("unable to replace deltaCertificateDescriptor: " + iOException.getMessage());
                }
            }
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        try {
            tBSCertificate = this.tbsGen.generateTBSCertificate();
            return new X509CertificateHolder(X509v3CertificateBuilder.generateStructure(tBSCertificate, contentSigner.getAlgorithmIdentifier(), X509v3CertificateBuilder.generateSig(contentSigner, (ASN1Object)tBSCertificate)));
        }
        catch (IOException iOException) {
            throw Exceptions.illegalArgumentException((String)"cannot produce certificate signature", (Throwable)iOException);
        }
    }

    private static byte[] generateSig(ContentSigner contentSigner, ASN1Object aSN1Object) throws IOException {
        OutputStream outputStream = contentSigner.getOutputStream();
        aSN1Object.encodeTo(outputStream, "DER");
        outputStream.close();
        return contentSigner.getSignature();
    }

    private static Certificate generateStructure(TBSCertificate tBSCertificate, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)tBSCertificate);
        aSN1EncodableVector.add((ASN1Encodable)algorithmIdentifier);
        aSN1EncodableVector.add((ASN1Encodable)new DERBitString(byArray));
        return Certificate.getInstance((Object)new DERSequence(aSN1EncodableVector));
    }
}

