/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.cert;

import de.businesslogics.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import de.businesslogics.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.cert.CertRuntimeException;
import de.businesslogics.bouncycastle.operator.DigestCalculator;
import java.io.IOException;
import java.io.OutputStream;

public class X509ExtensionUtils {
    private DigestCalculator calculator;

    public X509ExtensionUtils(DigestCalculator digestCalculator) {
        this.calculator = digestCalculator;
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new AuthorityKeyIdentifier(this.calculateIdentifier(subjectPublicKeyInfo));
    }

    public SubjectKeyIdentifier createSubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new SubjectKeyIdentifier(this.calculateIdentifier(subjectPublicKeyInfo));
    }

    private byte[] calculateIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        byte[] byArray = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        OutputStream outputStream = this.calculator.getOutputStream();
        try {
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CertRuntimeException("unable to calculate identifier: " + iOException.getMessage(), iOException);
        }
        return this.calculator.getDigest();
    }
}

