/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.cert;

import de.businesslogics.bouncycastle.asn1.x509.Certificate;
import de.businesslogics.bouncycastle.asn1.x509.Extensions;
import de.businesslogics.bouncycastle.cert.CertIOException;
import de.businesslogics.bouncycastle.cert.CertUtils;
import de.businesslogics.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.Serializable;

public class X509CertificateHolder
implements Encodable,
Serializable {
    private transient Certificate x509Certificate;
    private transient Extensions extensions;

    private static Certificate parseBytes(byte[] byArray) throws IOException {
        try {
            return Certificate.getInstance((Object)CertUtils.parseNonEmptyASN1(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public X509CertificateHolder(byte[] byArray) throws IOException {
        this(X509CertificateHolder.parseBytes(byArray));
    }

    public X509CertificateHolder(Certificate certificate) {
        this.init(certificate);
    }

    private void init(Certificate certificate) {
        this.x509Certificate = certificate;
        this.extensions = certificate.getTBSCertificate().getExtensions();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509CertificateHolder)) {
            return false;
        }
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
        return this.x509Certificate.equals((Object)x509CertificateHolder.x509Certificate);
    }

    public int hashCode() {
        return this.x509Certificate.hashCode();
    }

    public byte[] getEncoded() throws IOException {
        return this.x509Certificate.getEncoded();
    }
}

