/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.cert;

import de.businesslogics.bouncycastle.asn1.x509.Attribute;
import de.businesslogics.bouncycastle.asn1.x509.AttributeCertificate;
import de.businesslogics.bouncycastle.asn1.x509.Extensions;
import de.businesslogics.bouncycastle.cert.CertIOException;
import de.businesslogics.bouncycastle.cert.CertUtils;
import de.businesslogics.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.Serializable;

public class X509AttributeCertificateHolder
implements Encodable,
Serializable {
    private static Attribute[] EMPTY_ARRAY = new Attribute[0];
    private transient AttributeCertificate attrCert;
    private transient Extensions extensions;

    private static AttributeCertificate parseBytes(byte[] byArray) throws IOException {
        try {
            return AttributeCertificate.getInstance((Object)CertUtils.parseNonEmptyASN1(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public X509AttributeCertificateHolder(byte[] byArray) throws IOException {
        this(X509AttributeCertificateHolder.parseBytes(byArray));
    }

    public X509AttributeCertificateHolder(AttributeCertificate attributeCertificate) {
        this.init(attributeCertificate);
    }

    private void init(AttributeCertificate attributeCertificate) {
        this.attrCert = attributeCertificate;
        this.extensions = attributeCertificate.getAcinfo().getExtensions();
    }

    public byte[] getEncoded() throws IOException {
        return this.attrCert.getEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509AttributeCertificateHolder)) {
            return false;
        }
        X509AttributeCertificateHolder x509AttributeCertificateHolder = (X509AttributeCertificateHolder)object;
        return this.attrCert.equals((Object)x509AttributeCertificateHolder.attrCert);
    }

    public int hashCode() {
        return this.attrCert.hashCode();
    }
}

