/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.newhope;

import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import de.businesslogics.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import de.businesslogics.bouncycastle.pqc.jcajce.interfaces.NHPublicKey;
import de.businesslogics.bouncycastle.util.Arrays;
import java.io.IOException;

public class BCNHPublicKey
implements NHPublicKey {
    private transient NHPublicKeyParameters params;

    public BCNHPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (NHPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCNHPublicKey)) {
            return false;
        }
        BCNHPublicKey bCNHPublicKey = (BCNHPublicKey)object;
        return Arrays.areEqual(this.params.getPubData(), bCNHPublicKey.params.getPubData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getPubData());
    }

    public final String getAlgorithm() {
        return "NH";
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }
}

