/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.kyber;

import de.businesslogics.bouncycastle.asn1.ASN1Set;
import de.businesslogics.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import de.businesslogics.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import de.businesslogics.bouncycastle.pqc.jcajce.interfaces.KyberPrivateKey;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.Strings;
import java.io.IOException;

public class BCKyberPrivateKey
implements KyberPrivateKey {
    private transient KyberPrivateKeyParameters params;
    private transient String algorithm;
    private transient ASN1Set attributes;

    public BCKyberPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (KyberPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
        this.algorithm = Strings.toUpperCase(this.params.getParameters().getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCKyberPrivateKey) {
            BCKyberPrivateKey bCKyberPrivateKey = (BCKyberPrivateKey)object;
            return Arrays.areEqual(this.getEncoded(), bCKyberPrivateKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }
}

