/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.hqc;

import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import de.businesslogics.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import de.businesslogics.bouncycastle.pqc.jcajce.interfaces.HQCKey;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.Strings;
import java.io.IOException;
import java.security.PublicKey;

public class BCHQCPublicKey
implements HQCKey,
PublicKey {
    private transient HQCPublicKeyParameters params;

    public BCHQCPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (HQCPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCHQCPublicKey) {
            BCHQCPublicKey bCHQCPublicKey = (BCHQCPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCHQCPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }
}

