/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.cmce;

import de.businesslogics.bouncycastle.asn1.ASN1Set;
import de.businesslogics.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import de.businesslogics.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import de.businesslogics.bouncycastle.pqc.jcajce.interfaces.CMCEKey;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.Strings;
import java.io.IOException;
import java.security.PrivateKey;

public class BCCMCEPrivateKey
implements CMCEKey,
PrivateKey {
    private transient CMCEPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCCMCEPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (CMCEPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCCMCEPrivateKey) {
            BCCMCEPrivateKey bCCMCEPrivateKey = (BCCMCEPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCCMCEPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }
}

