/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.crypto.saber;

import de.businesslogics.bouncycastle.crypto.StreamCipher;
import de.businesslogics.bouncycastle.crypto.Xof;
import de.businesslogics.bouncycastle.crypto.digests.SHA256Digest;
import de.businesslogics.bouncycastle.crypto.digests.SHA3Digest;
import de.businesslogics.bouncycastle.crypto.digests.SHA512Digest;
import de.businesslogics.bouncycastle.crypto.digests.SHAKEDigest;
import de.businesslogics.bouncycastle.crypto.engines.AESEngine;
import de.businesslogics.bouncycastle.crypto.modes.SICBlockCipher;

abstract class Symmetric {
    Symmetric() {
    }

    static class AesSymmetric
    extends Symmetric {
        private final SHA256Digest sha256Digest = new SHA256Digest();
        private final SHA512Digest sha512Digest = new SHA512Digest();
        private final StreamCipher cipher = SICBlockCipher.newInstance(AESEngine.newInstance());

        AesSymmetric() {
        }
    }

    static class ShakeSymmetric
    extends Symmetric {
        private final SHA3Digest sha3Digest256;
        private final SHA3Digest sha3Digest512;
        private final Xof shakeDigest = new SHAKEDigest(128);

        ShakeSymmetric() {
            this.sha3Digest256 = new SHA3Digest(256);
            this.sha3Digest512 = new SHA3Digest(512);
        }
    }
}

