/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.crypto.rainbow;

import de.businesslogics.bouncycastle.util.Pack;

class GF2Field {
    static final byte[][] gfMulTable;
    static final byte[] gfInvTable;

    public static short addElem(short s, short s2) {
        return (short)(s ^ s2);
    }

    public static short multElem(short s, short s2) {
        return (short)(gfMulTable[s][s2] & 0xFF);
    }

    private static long gf4Mul2_64(long l) {
        long l2 = l & 0x5555555555555555L;
        long l3 = l & 0xAAAAAAAAAAAAAAAAL;
        return l3 ^ l2 << 1 ^ l3 >>> 1;
    }

    private static long gf4Mul_64(long l, long l2) {
        long l3 = (l << 1 & l2 ^ l2 << 1 & l) & 0xAAAAAAAAAAAAAAAAL;
        long l4 = l & l2;
        return l4 ^ l3 ^ (l4 & 0xAAAAAAAAAAAAAAAAL) >>> 1;
    }

    private static long gf4Squ_64(long l) {
        long l2 = l & 0xAAAAAAAAAAAAAAAAL;
        return l ^ l2 >>> 1;
    }

    private static long gf16Mul_64(long l, long l2) {
        long l3 = GF2Field.gf4Mul_64(l, l2);
        long l4 = l3 & 0x3333333333333333L;
        long l5 = l3 & 0xCCCCCCCCCCCCCCCCL;
        long l6 = (l << 2 ^ l) & 0xCCCCCCCCCCCCCCCCL ^ l5 >>> 2;
        long l7 = (l2 << 2 ^ l2) & 0xCCCCCCCCCCCCCCCCL ^ 0x2222222222222222L;
        long l8 = GF2Field.gf4Mul_64(l6, l7);
        return l8 ^ l4 << 2 ^ l4;
    }

    private static long gf16Squ_64(long l) {
        long l2 = GF2Field.gf4Squ_64(l);
        long l3 = GF2Field.gf4Mul2_64(l2 & 0xCCCCCCCCCCCCCCCCL);
        return l2 ^ l3 >>> 2;
    }

    private static long gf16Mul8_64(long l) {
        long l2 = l & 0x3333333333333333L;
        long l3 = l & 0xCCCCCCCCCCCCCCCCL;
        long l4 = l2 << 2 ^ l3 ^ l3 >>> 2;
        long l5 = GF2Field.gf4Mul2_64(l4);
        return l5 ^ l3 >>> 2;
    }

    private static long gf256Mul_64(long l, long l2) {
        long l3 = GF2Field.gf16Mul_64(l, l2);
        long l4 = l3 & 0xF0F0F0F0F0F0F0FL;
        long l5 = l3 & 0xF0F0F0F0F0F0F0F0L;
        long l6 = (l << 4 ^ l) & 0xF0F0F0F0F0F0F0F0L ^ l5 >>> 4;
        long l7 = (l2 << 4 ^ l2) & 0xF0F0F0F0F0F0F0F0L ^ 0x808080808080808L;
        long l8 = GF2Field.gf16Mul_64(l6, l7);
        return l8 ^ l4 << 4 ^ l4;
    }

    private static long gf256Squ_64(long l) {
        long l2 = GF2Field.gf16Squ_64(l);
        long l3 = l2 & 0xF0F0F0F0F0F0F0F0L;
        long l4 = GF2Field.gf16Mul8_64(l3);
        return l2 ^ l4 >>> 4;
    }

    private static long gf256Inv_64(long l) {
        long l2 = GF2Field.gf256Squ_64(l);
        long l3 = GF2Field.gf256Squ_64(l2);
        long l4 = GF2Field.gf256Squ_64(l3);
        long l5 = GF2Field.gf256Mul_64(l3, l2);
        long l6 = GF2Field.gf256Mul_64(l5, l4);
        long l7 = GF2Field.gf256Squ_64(l6);
        l7 = GF2Field.gf256Squ_64(l7);
        l7 = GF2Field.gf256Squ_64(l7);
        long l8 = GF2Field.gf256Mul_64(l7, l6);
        long l9 = GF2Field.gf256Squ_64(l8);
        return GF2Field.gf256Mul_64(l2, l9);
    }

    static {
        long l;
        int n;
        gfMulTable = new byte[256][256];
        gfInvTable = new byte[256];
        long l2 = 0x101010101010101L;
        for (n = 1; n <= 255; ++n) {
            l = 506097522914230528L;
            for (int i = 0; i < 256; i += 8) {
                long l3 = GF2Field.gf256Mul_64(l2, l);
                Pack.longToLittleEndian(l3, gfMulTable[n], i);
                l += 0x808080808080808L;
            }
            l2 += 0x101010101010101L;
        }
        l2 = 506097522914230528L;
        for (n = 0; n < 256; n += 8) {
            l = GF2Field.gf256Inv_64(l2);
            Pack.longToLittleEndian(l, gfInvTable, n);
            l2 += 0x808080808080808L;
        }
    }
}

