/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.crypto.rainbow;

import de.businesslogics.bouncycastle.pqc.crypto.rainbow.GF2Field;

class ComputeInField {
    public short[][] multiplyMatrix(short[][] sArray, short[][] sArray2) throws RuntimeException {
        if (sArray[0].length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short s = 0;
        short[][] sArray3 = new short[sArray.length][sArray2[0].length];
        for (int i = 0; i < sArray.length; ++i) {
            for (int j = 0; j < sArray2.length; ++j) {
                for (int k = 0; k < sArray2[0].length; ++k) {
                    s = GF2Field.multElem(sArray[i][j], sArray2[j][k]);
                    sArray3[i][k] = GF2Field.addElem(sArray3[i][k], s);
                }
            }
        }
        return sArray3;
    }

    public short[][] addMatrix(short[][] sArray, short[][] sArray2) {
        if (sArray.length != sArray2.length || sArray[0].length != sArray2[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        short[][] sArray3 = new short[sArray.length][sArray[0].length];
        for (int i = 0; i < sArray.length; ++i) {
            for (int j = 0; j < sArray[0].length; ++j) {
                sArray3[i][j] = GF2Field.addElem(sArray[i][j], sArray2[i][j]);
            }
        }
        return sArray3;
    }

    public short[][] addMatrixTranspose(short[][] sArray) {
        if (sArray.length != sArray[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        return this.addMatrix(sArray, this.transpose(sArray));
    }

    public short[][] transpose(short[][] sArray) {
        short[][] sArray2 = new short[sArray[0].length][sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            for (int j = 0; j < sArray[0].length; ++j) {
                sArray2[j][i] = sArray[i][j];
            }
        }
        return sArray2;
    }

    public short[][] to_UT(short[][] sArray) {
        if (sArray.length != sArray[0].length) {
            throw new RuntimeException("Computation to upper triangular matrix is not possible!");
        }
        short[][] sArray2 = new short[sArray.length][sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray2[i][i] = sArray[i][i];
            for (int j = i + 1; j < sArray[0].length; ++j) {
                sArray2[i][j] = GF2Field.addElem(sArray[i][j], sArray[j][i]);
            }
        }
        return sArray2;
    }

    public short[][][] obfuscate_l1_polys(short[][] sArray, short[][][] sArray2, short[][][] sArray3) {
        if (sArray2[0].length != sArray3[0].length || sArray2[0][0].length != sArray3[0][0].length || sArray2.length != sArray[0].length || sArray3.length != sArray.length) {
            throw new RuntimeException("Multiplication not possible!");
        }
        short[][][] sArray4 = new short[sArray3.length][sArray3[0].length][sArray3[0][0].length];
        for (int i = 0; i < sArray2[0].length; ++i) {
            for (int j = 0; j < sArray2[0][0].length; ++j) {
                for (int k = 0; k < sArray.length; ++k) {
                    for (int i2 = 0; i2 < sArray[0].length; ++i2) {
                        short s = GF2Field.multElem(sArray[k][i2], sArray2[i2][i][j]);
                        sArray4[k][i][j] = GF2Field.addElem(sArray4[k][i][j], s);
                    }
                    sArray4[k][i][j] = GF2Field.addElem(sArray3[k][i][j], sArray4[k][i][j]);
                }
            }
        }
        return sArray4;
    }
}

