/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.crypto.hqc;

import de.businesslogics.bouncycastle.pqc.crypto.hqc.GF2PolynomialCalculator;
import de.businesslogics.bouncycastle.pqc.crypto.hqc.Utils;

class HQCEngine {
    private int n;
    private int n1;
    private int n2;
    private int k;
    private int delta;
    private int w;
    private int wr;
    private int we;
    private int g;
    private int rejectionThreshold;
    private int fft;
    private int mulParam;
    private int SEED_SIZE = 40;
    private byte G_FCT_DOMAIN = (byte)3;
    private byte H_FCT_DOMAIN = (byte)4;
    private byte K_FCT_DOMAIN = (byte)5;
    private int N_BYTE;
    private int n1n2;
    private int N_BYTE_64;
    private int K_BYTE;
    private int K_BYTE_64;
    private int N1_BYTE_64;
    private int N1N2_BYTE_64;
    private int N1N2_BYTE;
    private int N1_BYTE;
    private int GF_POLY_WT = 5;
    private int GF_POLY_M2 = 4;
    private int SALT_SIZE_BYTES = 16;
    private int SALT_SIZE_64 = 2;
    private int[] generatorPoly;
    private int SHA512_BYTES = 64;
    private long RED_MASK;
    private GF2PolynomialCalculator gfCalculator;

    public HQCEngine(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int[] nArray) {
        this.n = n;
        this.k = n4;
        this.delta = n6;
        this.w = n7;
        this.wr = n8;
        this.we = n9;
        this.n1 = n2;
        this.n2 = n3;
        this.n1n2 = n2 * n3;
        this.generatorPoly = nArray;
        this.g = n5;
        this.rejectionThreshold = n10;
        this.fft = n11;
        this.mulParam = (int)Math.ceil(n3 / 128);
        this.N_BYTE = Utils.getByteSizeFromBitSize(n);
        this.K_BYTE = n4;
        this.N_BYTE_64 = Utils.getByte64SizeFromBitSize(n);
        this.K_BYTE_64 = Utils.getByteSizeFromBitSize(n4);
        this.N1_BYTE_64 = Utils.getByteSizeFromBitSize(n2);
        this.N1N2_BYTE_64 = Utils.getByte64SizeFromBitSize(n2 * n3);
        this.N1N2_BYTE = Utils.getByteSizeFromBitSize(n2 * n3);
        this.N1_BYTE = Utils.getByteSizeFromBitSize(n2);
        this.RED_MASK = (1L << (int)((long)n % 64L)) - 1L;
        this.gfCalculator = new GF2PolynomialCalculator(this.N_BYTE_64, n, this.RED_MASK);
    }
}

