/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.asn1;

import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1Object;
import de.businesslogics.bouncycastle.asn1.ASN1OctetString;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.DEROctetString;
import de.businesslogics.bouncycastle.asn1.DERSequence;
import de.businesslogics.bouncycastle.util.Arrays;

public class CMCEPublicKey
extends ASN1Object {
    private byte[] T;

    public CMCEPublicKey(byte[] byArray) {
        this.T = byArray;
    }

    public CMCEPublicKey(ASN1Sequence aSN1Sequence) {
        this.T = Arrays.clone(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets());
    }

    public byte[] getT() {
        return Arrays.clone(this.T);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(this.T));
        return new DERSequence(aSN1EncodableVector);
    }

    public static CMCEPublicKey getInstance(Object object) {
        if (object instanceof CMCEPublicKey) {
            return (CMCEPublicKey)object;
        }
        if (object != null) {
            return new CMCEPublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }
}

