/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.jce;

import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.x509.TBSCertificateStructure;
import de.businesslogics.bouncycastle.asn1.x509.X509Name;
import de.businesslogics.bouncycastle.jce.X509Principal;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class PrincipalUtil {
    public static X509Principal getSubjectX509Principal(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(x509Certificate.getTBSCertificate()));
            return new X509Principal(X509Name.getInstance(tBSCertificateStructure.getSubject()));
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }
}

