/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.jce;

import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import de.businesslogics.bouncycastle.asn1.x9.X9ECParameters;
import de.businesslogics.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public class ECGOST3410NamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String string) {
        X9ECParameters x9ECParameters = ECGOST3410NamedCurves.getByNameX9(string);
        if (x9ECParameters == null) {
            try {
                x9ECParameters = ECGOST3410NamedCurves.getByOIDX9(new ASN1ObjectIdentifier(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (x9ECParameters == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(string, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }
}

