/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.jcajce.provider.symmetric.util;

import de.businesslogics.bouncycastle.crypto.CipherParameters;
import de.businesslogics.bouncycastle.crypto.CryptoServicePurpose;
import de.businesslogics.bouncycastle.crypto.PBEParametersGenerator;
import de.businesslogics.bouncycastle.crypto.digests.GOST3411Digest;
import de.businesslogics.bouncycastle.crypto.digests.MD2Digest;
import de.businesslogics.bouncycastle.crypto.digests.RIPEMD160Digest;
import de.businesslogics.bouncycastle.crypto.digests.SM3Digest;
import de.businesslogics.bouncycastle.crypto.digests.TigerDigest;
import de.businesslogics.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import de.businesslogics.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import de.businesslogics.bouncycastle.crypto.generators.PKCS5S1ParametersGenerator;
import de.businesslogics.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import de.businesslogics.bouncycastle.crypto.params.DESParameters;
import de.businesslogics.bouncycastle.crypto.params.KeyParameter;
import de.businesslogics.bouncycastle.crypto.params.ParametersWithIV;
import de.businesslogics.bouncycastle.crypto.util.DigestFactory;
import de.businesslogics.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public interface PBE {

    public static class Util {
        private static PBEParametersGenerator makePBEGenerator(int n, int n2) {
            PBEParametersGenerator pBEParametersGenerator;
            block35: {
                block37: {
                    block36: {
                        block34: {
                            if (n != 0 && n != 4) break block34;
                            switch (n2) {
                                case 5: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(new MD2Digest());
                                    break block35;
                                }
                                case 0: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(DigestFactory.createMD5());
                                    break block35;
                                }
                                case 1: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(DigestFactory.createSHA1());
                                    break block35;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports MD2, MD5 and SHA1.");
                                }
                            }
                        }
                        if (n != 1 && n != 5) break block36;
                        switch (n2) {
                            case 5: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new MD2Digest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            case 0: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createMD5PRF());
                                break block35;
                            }
                            case 1: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA1PRF());
                                break block35;
                            }
                            case 2: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new RIPEMD160Digest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            case 3: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new TigerDigest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            case 4: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA256PRF());
                                break block35;
                            }
                            case 6: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new GOST3411Digest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            case 7: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA224PRF());
                                break block35;
                            }
                            case 8: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA384PRF());
                                break block35;
                            }
                            case 9: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA512PRF());
                                break block35;
                            }
                            case 10: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_224PRF());
                                break block35;
                            }
                            case 11: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_256PRF());
                                break block35;
                            }
                            case 12: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_384PRF());
                                break block35;
                            }
                            case 13: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_512PRF());
                                break block35;
                            }
                            case 14: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new SM3Digest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            default: {
                                throw new IllegalStateException("unknown digest scheme for PBE PKCS5S2 encryption.");
                            }
                        }
                    }
                    if (n != 2) break block37;
                    switch (n2) {
                        case 5: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new MD2Digest(CryptoServicePurpose.PRF));
                            break block35;
                        }
                        case 0: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createMD5PRF());
                            break block35;
                        }
                        case 1: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA1PRF());
                            break block35;
                        }
                        case 2: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new RIPEMD160Digest(CryptoServicePurpose.PRF));
                            break block35;
                        }
                        case 3: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new TigerDigest(CryptoServicePurpose.PRF));
                            break block35;
                        }
                        case 4: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA256PRF());
                            break block35;
                        }
                        case 6: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new GOST3411Digest(CryptoServicePurpose.PRF));
                            break block35;
                        }
                        case 7: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA224PRF());
                            break block35;
                        }
                        case 8: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA384PRF());
                            break block35;
                        }
                        case 9: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA512PRF());
                            break block35;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                pBEParametersGenerator = new OpenSSLPBEParametersGenerator();
            }
            return pBEParametersGenerator;
        }

        public static CipherParameters makePBEParameters(byte[] byArray, int n, int n2, int n3, int n4, AlgorithmParameterSpec algorithmParameterSpec, String string) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            byte[] byArray2 = byArray;
            pBEParametersGenerator.init(byArray2, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = n4 != 0 ? pBEParametersGenerator.generateDerivedParameters(n3, n4) : pBEParametersGenerator.generateDerivedParameters(n3);
            if (string.startsWith("DES")) {
                if (cipherParameters instanceof ParametersWithIV) {
                    KeyParameter keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    DESParameters.setOddParity(keyParameter.getKey());
                } else {
                    KeyParameter keyParameter = (KeyParameter)cipherParameters;
                    DESParameters.setOddParity(keyParameter.getKey());
                }
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEParameters(BCPBEKey bCPBEKey, AlgorithmParameterSpec algorithmParameterSpec, String string) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(bCPBEKey.getType(), bCPBEKey.getDigest());
            byte[] byArray = bCPBEKey.getEncoded();
            if (bCPBEKey.shouldTryWrongPKCS12()) {
                byArray = new byte[2];
            }
            pBEParametersGenerator.init(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = bCPBEKey.getIvSize() != 0 ? pBEParametersGenerator.generateDerivedParameters(bCPBEKey.getKeySize(), bCPBEKey.getIvSize()) : pBEParametersGenerator.generateDerivedParameters(bCPBEKey.getKeySize());
            if (string.startsWith("DES")) {
                if (cipherParameters instanceof ParametersWithIV) {
                    KeyParameter keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    DESParameters.setOddParity(keyParameter.getKey());
                } else {
                    KeyParameter keyParameter = (KeyParameter)cipherParameters;
                    DESParameters.setOddParity(keyParameter.getKey());
                }
            }
            return cipherParameters;
        }
    }
}

