/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.jcajce.provider.asymmetric.ec;

import de.businesslogics.bouncycastle.asn1.ASN1BitString;
import de.businesslogics.bouncycastle.asn1.ASN1OctetString;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.DEROctetString;
import de.businesslogics.bouncycastle.asn1.x509.AlgorithmIdentifier;
import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.asn1.x9.X962Parameters;
import de.businesslogics.bouncycastle.asn1.x9.X9ECPoint;
import de.businesslogics.bouncycastle.asn1.x9.X9IntegerConverter;
import de.businesslogics.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import de.businesslogics.bouncycastle.crypto.params.ECPublicKeyParameters;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import de.businesslogics.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import de.businesslogics.bouncycastle.jce.spec.ECPublicKeySpec;
import de.businesslogics.bouncycastle.math.ec.ECCurve;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.Properties;
import java.io.IOException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class BCECPublicKey
implements de.businesslogics.bouncycastle.jce.interfaces.ECPublicKey,
ECPublicKey {
    private String algorithm = "EC";
    private boolean withCompression;
    private transient ECPublicKeyParameters ecPublicKey;
    private transient ECParameterSpec ecSpec;
    private transient ProviderConfiguration configuration;
    private transient byte[] encoding;
    private transient boolean oldPcSet;

    public BCECPublicKey(String string, java.security.spec.ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        this.ecSpec = eCPublicKeySpec.getParams();
        this.ecPublicKey = new ECPublicKeyParameters(EC5Util.convertPoint(this.ecSpec, eCPublicKeySpec.getW()), EC5Util.getDomainParameters(providerConfiguration, eCPublicKeySpec.getParams()));
        this.configuration = providerConfiguration;
    }

    public BCECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        if (eCPublicKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPublicKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPublicKeySpec.getParams().getSeed());
            this.ecPublicKey = new ECPublicKeyParameters(eCPublicKeySpec.getQ(), ECUtil.getDomainParameters(providerConfiguration, eCPublicKeySpec.getParams()));
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, eCPublicKeySpec.getParams());
        } else {
            de.businesslogics.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = providerConfiguration.getEcImplicitlyCa();
            this.ecPublicKey = new ECPublicKeyParameters(eCParameterSpec.getCurve().createPoint(eCPublicKeySpec.getQ().getAffineXCoord().toBigInteger(), eCPublicKeySpec.getQ().getAffineYCoord().toBigInteger()), EC5Util.getDomainParameters(providerConfiguration, null));
            this.ecSpec = null;
        }
        this.configuration = providerConfiguration;
    }

    public BCECPublicKey(ECPublicKey eCPublicKey, ProviderConfiguration providerConfiguration) {
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParams();
        this.ecPublicKey = new ECPublicKeyParameters(EC5Util.convertPoint(this.ecSpec, eCPublicKey.getW()), EC5Util.getDomainParameters(providerConfiguration, eCPublicKey.getParams()));
        this.configuration = providerConfiguration;
    }

    BCECPublicKey(String string, SubjectPublicKeyInfo subjectPublicKeyInfo, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        this.configuration = providerConfiguration;
        this.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        int n;
        X962Parameters x962Parameters = X962Parameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        ECCurve eCCurve = EC5Util.getCurve(this.configuration, x962Parameters);
        this.ecSpec = EC5Util.convertToSpec(x962Parameters, eCCurve);
        ASN1BitString aSN1BitString = subjectPublicKeyInfo.getPublicKeyData();
        byte[] byArray = aSN1BitString.getBytes();
        ASN1OctetString aSN1OctetString = new DEROctetString(byArray);
        if (byArray[0] == 4 && byArray[1] == byArray.length - 2 && (byArray[2] == 2 || byArray[2] == 3) && (n = new X9IntegerConverter().getByteLength(eCCurve)) >= byArray.length - 3) {
            try {
                aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        X9ECPoint x9ECPoint = new X9ECPoint(eCCurve, aSN1OctetString);
        this.ecPublicKey = new ECPublicKeyParameters(x9ECPoint.getPoint(), ECUtil.getDomainParameters(this.configuration, x962Parameters));
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        boolean bl = Properties.isOverrideSet("de.businesslogics.bouncycastle.ec.enable_pc");
        if (this.encoding == null || this.oldPcSet != bl) {
            boolean bl2 = this.withCompression || bl;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, ECUtils.getDomainParametersFromName(this.ecSpec, bl2));
            byte[] byArray = this.ecPublicKey.getQ().getEncoded(bl2);
            this.encoding = KeyUtil.getEncodedSubjectPublicKeyInfo(algorithmIdentifier, byArray);
            this.oldPcSet = bl;
        }
        return Arrays.clone(this.encoding);
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public de.businesslogics.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(this.ecSpec);
    }

    public ECPoint getW() {
        return EC5Util.convertPoint(this.ecPublicKey.getQ());
    }

    public de.businesslogics.bouncycastle.math.ec.ECPoint getQ() {
        de.businesslogics.bouncycastle.math.ec.ECPoint eCPoint = this.ecPublicKey.getQ();
        if (this.ecSpec == null) {
            return eCPoint.getDetachedPoint();
        }
        return eCPoint;
    }

    de.businesslogics.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec(this.ecSpec);
        }
        return this.configuration.getEcImplicitlyCa();
    }

    public String toString() {
        return ECUtil.publicKeyToString("EC", this.ecPublicKey.getQ(), this.engineGetSpec());
    }

    public boolean equals(Object object) {
        if (object instanceof BCECPublicKey) {
            BCECPublicKey bCECPublicKey = (BCECPublicKey)object;
            return this.ecPublicKey.getQ().equals(bCECPublicKey.ecPublicKey.getQ()) && this.engineGetSpec().equals(bCECPublicKey.engineGetSpec());
        }
        if (object instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)object;
            return Arrays.areEqual(this.getEncoded(), eCPublicKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return this.ecPublicKey.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }
}

