/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.jcajce.provider.asymmetric.dsa;

import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import de.businesslogics.bouncycastle.crypto.params.DSAParameters;
import de.businesslogics.bouncycastle.internal.asn1.oiw.OIWObjectIdentifiers;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.Fingerprint;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;

public class DSAUtil {
    public static final ASN1ObjectIdentifier[] dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1, X9ObjectIdentifiers.id_dsa_with_sha1};

    public static boolean isDsaOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        for (int i = 0; i != dsaOids.length; ++i) {
            if (!aSN1ObjectIdentifier.equals(dsaOids[i])) continue;
            return true;
        }
        return false;
    }

    static DSAParameters toDSAParameters(DSAParams dSAParams) {
        if (dSAParams != null) {
            return new DSAParameters(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
        }
        return null;
    }

    static String generateKeyFingerprint(BigInteger bigInteger, DSAParams dSAParams) {
        return new Fingerprint(Arrays.concatenate(bigInteger.toByteArray(), dSAParams.getP().toByteArray(), dSAParams.getQ().toByteArray(), dSAParams.getG().toByteArray())).toString();
    }
}

