/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.crypto.paddings;

import de.businesslogics.bouncycastle.crypto.InvalidCipherTextException;
import de.businesslogics.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    public int addPadding(byte[] byArray, int n) {
        byte by = (byte)(byArray.length - n);
        while (n < byArray.length) {
            byArray[n] = by;
            ++n;
        }
        return by;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        byte by = byArray[byArray.length - 1];
        int n = by & 0xFF;
        int n2 = byArray.length - n;
        int n3 = (n2 | n - 1) >> 31;
        for (int i = 0; i < byArray.length; ++i) {
            n3 |= (byArray[i] ^ by) & ~(i - n2 >> 31);
        }
        if (n3 != 0) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n;
    }
}

