/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1.x509;

import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1Integer;
import de.businesslogics.bouncycastle.asn1.ASN1Object;
import de.businesslogics.bouncycastle.asn1.ASN1OctetString;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.DEROctetString;
import de.businesslogics.bouncycastle.asn1.DERSequence;
import de.businesslogics.bouncycastle.asn1.DERTaggedObject;
import de.businesslogics.bouncycastle.asn1.x509.GeneralNames;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class AuthorityKeyIdentifier
extends ASN1Object {
    ASN1OctetString keyidentifier = null;
    GeneralNames certissuer = null;
    ASN1Integer certserno = null;

    public AuthorityKeyIdentifier(byte[] byArray) {
        this(byArray, null, null);
    }

    public AuthorityKeyIdentifier(byte[] byArray, GeneralNames generalNames, BigInteger bigInteger) {
        this.keyidentifier = byArray != null ? new DEROctetString(Arrays.clone(byArray)) : null;
        this.certissuer = generalNames;
        this.certserno = bigInteger != null ? new ASN1Integer(bigInteger) : null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        if (this.keyidentifier != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.keyidentifier));
        }
        if (this.certissuer != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.certissuer));
        }
        if (this.certserno != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.certserno));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        String string = this.keyidentifier != null ? Hex.toHexString(this.keyidentifier.getOctets()) : "null";
        return "AuthorityKeyIdentifier: KeyID(" + string + ")";
    }
}

