/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1.x509;

import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1GeneralizedTime;
import de.businesslogics.bouncycastle.asn1.ASN1Object;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.DERSequence;

public class AttCertValidityPeriod
extends ASN1Object {
    ASN1GeneralizedTime notBeforeTime;
    ASN1GeneralizedTime notAfterTime;

    public static AttCertValidityPeriod getInstance(Object object) {
        if (object instanceof AttCertValidityPeriod) {
            return (AttCertValidityPeriod)object;
        }
        if (object != null) {
            return new AttCertValidityPeriod(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private AttCertValidityPeriod(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.notBeforeTime = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(0));
        this.notAfterTime = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.notBeforeTime);
        aSN1EncodableVector.add(this.notAfterTime);
        return new DERSequence(aSN1EncodableVector);
    }
}

