/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1.x500;

import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1Object;
import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.DERSequence;

public class AttributeTypeAndValue
extends ASN1Object {
    private ASN1ObjectIdentifier type;
    private ASN1Encodable value;

    private AttributeTypeAndValue(ASN1Sequence aSN1Sequence) {
        this.type = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.value = aSN1Sequence.getObjectAt(1);
    }

    public static AttributeTypeAndValue getInstance(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            return (AttributeTypeAndValue)object;
        }
        if (object != null) {
            return new AttributeTypeAndValue(ASN1Sequence.getInstance(object));
        }
        throw new IllegalArgumentException("null value in getInstance()");
    }

    public ASN1ObjectIdentifier getType() {
        return this.type;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.type);
        aSN1EncodableVector.add(this.value);
        return new DERSequence(aSN1EncodableVector);
    }
}

