/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1;

import de.businesslogics.bouncycastle.asn1.ASN1OutputStream;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1String;
import de.businesslogics.bouncycastle.asn1.ASN1UniversalType;
import de.businesslogics.bouncycastle.asn1.DEROctetString;
import de.businesslogics.bouncycastle.asn1.DERT61String;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class ASN1T61String
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1T61String.class, 20){

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1T61String.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    ASN1T61String(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public final String getString() {
        return Strings.fromByteArray(this.contents);
    }

    public String toString() {
        return this.getString();
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 20, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1T61String)) {
            return false;
        }
        ASN1T61String aSN1T61String = (ASN1T61String)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1T61String.contents);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1T61String createPrimitive(byte[] byArray) {
        return new DERT61String(byArray, false);
    }
}

