/*
 * Decompiled with CFR 0.152.
 */
package play.db;

import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Environment;
import play.db.ConnectionPool;
import play.db.DBApi;
import play.db.Database;
import play.db.DefaultConnectionPool;
import play.db.DefaultDBApi;
import play.db.NamedDatabase;
import play.db.NamedDatabaseImpl;
import play.inject.Binding;
import play.inject.Module;

public final class DBModule
extends Module {
    private static final Logger logger = LoggerFactory.getLogger(DBModule.class);

    public List<Binding<?>> bindings(Environment environment, Config config) {
        String string = config.getString("play.db.config");
        String string2 = config.getString("play.db.default");
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)DBModule.bindClass(ConnectionPool.class).to(DefaultConnectionPool.class));
        builder.add((Object)DBModule.bindClass(DBApi.class).to(DefaultDBApi.class));
        try {
            Set set = config.getConfig(string).root().keySet();
            for (String string3 : set) {
                builder.add((Object)DBModule.bindClass(Database.class).qualifiedWith((Annotation)this.named(string3)).to((Provider)new NamedDatabaseProvider(string3)));
            }
            if (set.contains(string2)) {
                builder.add((Object)DBModule.bindClass(Database.class).to(DBModule.bindClass(Database.class).qualifiedWith((Annotation)this.named(string2))));
            }
        }
        catch (ConfigException.Missing missing) {
            logger.warn("Configuration not found for database: {}", (Object)missing.getMessage());
        }
        return builder.build();
    }

    private NamedDatabase named(String string) {
        return new NamedDatabaseImpl(string);
    }

    public static class NamedDatabaseProvider
    implements Provider<Database> {
        @Inject
        private DBApi dbApi = null;
        private final String name;

        public NamedDatabaseProvider(String string) {
            this.name = string;
        }

        public Database get() {
            return this.dbApi.getDatabase(this.name);
        }
    }
}

