/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;

public class AuthenticatorDataSerializer
extends StdSerializer<AuthenticatorData> {
    private ObjectConverter objectConverter;

    public AuthenticatorDataSerializer(ObjectConverter objectConverter) {
        super(AuthenticatorData.class);
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.objectConverter = objectConverter;
    }

    public void serialize(AuthenticatorData value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeBinary(new AuthenticatorDataConverter(this.objectConverter).convert(value));
    }
}

