/*
 * Decompiled with CFR 0.152.
 */
package play.filters.csrf;

import java.io.Serializable;
import java.util.Locale;
import play.api.MarkerContext$;
import play.api.http.HeaderNames$;
import play.api.http.HttpEntity;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorInfo;
import play.api.http.SessionConfiguration;
import play.api.libs.crypto.CSRFTokenSigner;
import play.api.mvc.Cookie;
import play.api.mvc.Cookie$;
import play.api.mvc.DiscardingCookie;
import play.api.mvc.DiscardingCookie$;
import play.api.mvc.Request;
import play.api.mvc.Request$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Session;
import play.core.Execution;
import play.filters.cors.CORSFilter$Attrs$;
import play.filters.csrf.CSRF;
import play.filters.csrf.CSRF$;
import play.filters.csrf.CSRF$Token$;
import play.filters.csrf.CSRF$TokenInfo$;
import play.filters.csrf.CSRFConfig;
import play.libs.typedmap.TypedKey;
import play.mvc.Http;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u000e\u001d\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001dI\u0006A1A\u0005\niCaa\u001b\u0001!\u0002\u0013Y\u0006\"\u0002*\u0001\t\u0003a\u0007\"\u00029\u0001\t\u0013\t\b\"B;\u0001\t\u00031\bbBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003'\u0001A\u0011AA\r\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u0011\u0011\r\u0001\u0005\u0002\u0005U\u0004bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a(\u0001\t\u0003\t\t\u000bC\u0004\u00020\u0002!I!!-\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003{\u0004A\u0011AA\u0000\u0005A\u00195K\u0015$BGRLwN\u001c%fYB,'O\u0003\u0002\u001e=\u0005!1m\u001d:g\u0015\ty\u0002%A\u0004gS2$XM]:\u000b\u0003\u0005\nA\u0001\u001d7bs\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fM\u0006!2/Z:tS>t7i\u001c8gS\u001e,(/\u0019;j_:\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\t!$H\u000f\u001d\u0006\u0003a\u0001\n1!\u00199j\u0013\t\u0011TF\u0001\u000bTKN\u001c\u0018n\u001c8D_:4\u0017nZ;sCRLwN\\\u0001\u000bGN\u0014hmQ8oM&<\u0007CA\u001b7\u001b\u0005a\u0012BA\u001c\u001d\u0005)\u00195K\u0015$D_:4\u0017nZ\u0001\fi>\\WM\\*jO:,'\u000f\u0005\u0002;\u007f5\t1H\u0003\u0002={\u000511M]=qi>T!AP\u0018\u0002\t1L'm]\u0005\u0003\u0001n\u0012qbQ*S\rR{7.\u001a8TS\u001etWM]\u0001\u000ei>\\WM\u001c)s_ZLG-\u001a:\u0011\u0005\r{eB\u0001#N\u001d\t)EJ\u0004\u0002G\u0017:\u0011qIS\u0007\u0002\u0011*\u0011\u0011JI\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\b\u0011\n\u0005uq\u0012B\u0001(\u001d\u0003\u0011\u00195K\u0015$\n\u0005A\u000b&!\u0004+pW\u0016t\u0007K]8wS\u0012,'O\u0003\u0002O9\u00051A(\u001b8jiz\"R\u0001V+W/b\u0003\"!\u000e\u0001\t\u000b)*\u0001\u0019A\u0016\t\u000bM*\u0001\u0019\u0001\u001b\t\u000ba*\u0001\u0019A\u001d\t\u000b\u0005+\u0001\u0019\u0001\"\u0002#9{7)Y2iK\u0012K'/Z2uSZ,7/F\u0001\\!\ra\u0016mY\u0007\u0002;*\u0011alX\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u0019\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002c;\n\u00191+\u001a;\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017\u0001\u00027b]\u001eT\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002kK\n11\u000b\u001e:j]\u001e\f!CT8DC\u000eDW\rR5sK\u000e$\u0018N^3tAQ!A+\u001c8p\u0011\u0015Q\u0003\u00021\u0001,\u0011\u0015\u0019\u0004\u00021\u00015\u0011\u0015A\u0004\u00021\u0001:\u0003=!xn[3o\u0013NDE\u000f\u001e9P]2LX#\u0001:\u0011\u0005\u0015\u001a\u0018B\u0001;'\u0005\u001d\u0011un\u001c7fC:\f!cZ3u)>\\WM\u001c+p-\u0006d\u0017\u000eZ1uKR\u0019q/a\u0001\u0011\u0007\u0015B(0\u0003\u0002zM\t1q\n\u001d;j_:\u0004\"a_@\u000f\u0005ql\bCA$'\u0013\tqh%\u0001\u0004Qe\u0016$WMZ\u0005\u0004U\u0006\u0005!B\u0001@'\u0011\u001d\t)A\u0003a\u0001\u0003\u000f\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiaL\u0001\u0004[Z\u001c\u0017\u0002BA\t\u0003\u0017\u0011QBU3rk\u0016\u001cH\u000fS3bI\u0016\u0014\u0018\u0001\u0006;bOJ+\u0017/^3ti\u001a\u0013x.\u001c%fC\u0012,'\u000f\u0006\u0003\u0002\b\u0005]\u0001bBA\u0003\u0017\u0001\u0007\u0011qA\u000b\u0005\u00037\t9\u0003\u0006\u0003\u0002\u001e\u0005e\u0002CBA\u0005\u0003?\t\u0019#\u0003\u0003\u0002\"\u0005-!a\u0002*fcV,7\u000f\u001e\t\u0005\u0003K\t9\u0003\u0004\u0001\u0005\u000f\u0005%BB1\u0001\u0002,\t\t\u0011)\u0005\u0003\u0002.\u0005M\u0002cA\u0013\u00020%\u0019\u0011\u0011\u0007\u0014\u0003\u000f9{G\u000f[5oOB\u0019Q%!\u000e\n\u0007\u0005]bEA\u0002B]fDq!!\u0002\r\u0001\u0004\ti\"\u0001\tuC\u001e\u0014V-];fgRDU-\u00193feR1\u0011qAA \u0003\u0003Bq!!\u0002\u000e\u0001\u0004\t9\u0001\u0003\u0005\u0002D5!\t\u0019AA#\u0003\u0015!xn[3o!\u0015)\u0013qIA&\u0013\r\tIE\n\u0002\ty\tLh.Y7f}A\u00191)!\u0014\n\u0007\u0005=\u0013KA\u0003U_.,g.\u0001\u0006uC\u001e\u0014V-];fgR,B!!\u0016\u0002\\Q1\u0011qKA/\u0003?\u0002b!!\u0003\u0002 \u0005e\u0003\u0003BA\u0013\u00037\"q!!\u000b\u000f\u0005\u0004\tY\u0003C\u0004\u0002\u00069\u0001\r!a\u0016\t\u000f\u0005\rc\u00021\u0001\u0002L\u00051B/Y4SKF,Xm\u001d;XSRDg*Z<U_.,g.\u0006\u0003\u0002f\u0005-D\u0003BA4\u0003[\u0002b!!\u0003\u0002 \u0005%\u0004\u0003BA\u0013\u0003W\"q!!\u000b\u0010\u0005\u0004\tY\u0003C\u0004\u0002\u0006=\u0001\r!a\u001a\u00029Q\fwMU3rk\u0016\u001cH\u000fS3bI\u0016\u0014x+\u001b;i\u001d\u0016<Hk\\6f]R!\u0011qAA:\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000f!B!a\u001e\u0002\fB!\u0011\u0011PAC\u001d\u0011\tY(a \u000f\u0007\u0019\u000bi(C\u0002\u0002\u000e\u0001JA!!!\u0002\u0004\u0006!\u0001\n\u001e;q\u0015\r\ti\u0001I\u0005\u0005\u0003\u000f\u000bII\u0001\bSKF,Xm\u001d;Ck&dG-\u001a:\u000b\t\u0005\u0005\u00151\u0011\u0005\b\u0003\u001b\u000b\u0002\u0019AA<\u00039\u0011X-];fgR\u0014U/\u001b7eKJ\fQbZ3oKJ\fG/\u001a+pW\u0016tWCAA&\u000399W\r\u001e%fC\u0012,'\u000fV8lK:$2a^AL\u0011\u001d\t)a\u0005a\u0001\u0003\u000f\t\u0011C]3rk&\u0014Xm]\"te\u001a\u001c\u0005.Z2l)\r\u0011\u0018Q\u0014\u0005\b\u0003\u000b!\u0002\u0019AA\u0004\u0003I\tG\r\u001a+pW\u0016tGk\u001c*fgB|gn]3\u0015\r\u0005\r\u0016\u0011VAV!\u0011\tI!!*\n\t\u0005\u001d\u00161\u0002\u0002\u0007%\u0016\u001cX\u000f\u001c;\t\u000f\u0005\u0015Q\u00031\u0001\u0002\b!9\u0011QV\u000bA\u0002\u0005\r\u0016A\u0002:fgVdG/A\u000ffqR\u0014\u0018m\u0019;DC\u000eDWmQ8oiJ|G\u000eR5sK\u000e$\u0018N^3t)\u0011\t\u0019,!/\u0011\t\u0015\n)L_\u0005\u0004\u0003o3#!B!se\u0006L\bBBA^-\u0001\u0007!0A\u0006iK\u0006$WM\u001d,bYV,\u0017\u0001G5t\u0007\u0006\u001c\u0007.Z1cY\u0016\u0014\u0015p\u00155be\u0016$7)Y2iKR\u0019!/!1\t\u000f\u00055v\u00031\u0001\u0002$\u0006A\u0011n]\"bG\",G\rF\u0002s\u0003\u000fDq!!,\u0019\u0001\u0004\t\u0019\u000bK\u0006\u0019\u0003\u0017\f\t.a5\u0002X\u0006e\u0007cA\u0013\u0002N&\u0019\u0011q\u001a\u0014\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0005\u0005U\u0017a\t*f]\u0006lW\r\u001a\u0011u_\u0002J7oQ1dQ\u0016\f'\r\\3CsNC\u0017M]3e\u0007\u0006\u001c\u0007.Z\u0001\u0006g&t7-Z\u0011\u0003\u00037\fQA\r\u00189]A\n1c\u00197fCJ$vn[3o\u0013\u001aLeN^1mS\u0012$\u0002\"!9\u0002n\u0006=\u0018\u0011 \t\u0007\u0003G\fI/a)\u000e\u0005\u0005\u0015(bAAtM\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005-\u0018Q\u001d\u0002\u0007\rV$XO]3\t\u000f\u0005\u0015\u0011\u00041\u0001\u0002\b!9\u0011\u0011_\rA\u0002\u0005M\u0018\u0001D3se>\u0014\b*\u00198eY\u0016\u0014\bcA\"\u0002v&\u0019\u0011q_)\u0003\u0019\u0015\u0013(o\u001c:IC:$G.\u001a:\t\r\u0005m\u0018\u00041\u0001{\u0003\ri7oZ\u0001\u0016Q\u0006\u001c\u0018J\u001c<bY&$7i\u001c8uK:$H+\u001f9f)\r\u0011(\u0011\u0001\u0005\b\u0003\u000bQ\u0002\u0019AA\u0004\u0001")
public class CSRFActionHelper {
    private final SessionConfiguration sessionConfiguration;
    private final CSRFConfig csrfConfig;
    private final CSRFTokenSigner tokenSigner;
    private final CSRF.TokenProvider tokenProvider;
    private final Set<String> NoCacheDirectives;

    private Set<String> NoCacheDirectives() {
        return this.NoCacheDirectives;
    }

    private boolean tokenIsHttpOnly() {
        if (this.csrfConfig.cookieName().isDefined()) {
            return this.csrfConfig.httpOnlyCookie();
        }
        return this.sessionConfiguration.httpOnly();
    }

    public Option<String> getTokenToValidate(RequestHeader request) {
        Option option;
        Option attrToken = CSRF$.MODULE$.getToken(request).map((Function1 & Serializable)x$11 -> x$11.value());
        Option<String> option2 = this.csrfConfig.cookieName();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String cookieName = (String)some.value();
            option = request.cookies().get(cookieName).map((Function1 & Serializable)x$12 -> x$12.value());
        } else if (None$.MODULE$.equals(option2)) {
            option = request.session().get(this.csrfConfig.tokenName());
        } else {
            throw new MatchError(option2);
        }
        Option cookieOrSessionToken = option;
        return cookieOrSessionToken.orElse((Function0 & Serializable)() -> attrToken).filter((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)CSRFActionHelper.$anonfun$getTokenToValidate$4(this, token)));
    }

    public RequestHeader tagRequestFromHeader(RequestHeader request) {
        return (RequestHeader)this.getTokenToValidate(request).fold((Function0 & Serializable)() -> request, (Function1 & Serializable)tokenValue -> {
            CSRF.Token token = new CSRF.Token($this.csrfConfig.tokenName(), (String)tokenValue);
            RequestHeader newReq = this.tagRequestHeader(request, (Function0<CSRF.Token>)(Function0 & Serializable)() -> token);
            if ($this.csrfConfig.signTokens()) {
                Option extractedTokenValue = $this.tokenSigner.extractSignedToken(token.value());
                return (RequestHeader)extractedTokenValue.fold((Function0 & Serializable)() -> newReq, (Function1 & Serializable)tv -> this.tagRequestHeader(newReq, (Function0<CSRF.Token>)(Function0 & Serializable)() -> {
                    String x$1 = $this.tokenSigner.signToken(tv);
                    String x$2 = token.copy$default$1();
                    return token.copy(x$2, x$1);
                }));
            }
            return newReq;
        });
    }

    public <A> Request<A> tagRequestFromHeader(Request<A> request) {
        return Request$.MODULE$.apply(this.tagRequestFromHeader((RequestHeader)request), request.body());
    }

    public RequestHeader tagRequestHeader(RequestHeader request, Function0<CSRF.Token> token) {
        return request.addAttr(CSRF$Token$.MODULE$.InfoAttr(), (Object)CSRF$TokenInfo$.MODULE$.apply(token));
    }

    public <A> Request<A> tagRequest(Request<A> request, CSRF.Token token) {
        return request.addAttr(CSRF$Token$.MODULE$.InfoAttr(), (Object)CSRF$TokenInfo$.MODULE$.apply((Function0<CSRF.Token>)(Function0 & Serializable)() -> token));
    }

    public <A> Request<A> tagRequestWithNewToken(Request<A> request) {
        return request.addAttr(CSRF$Token$.MODULE$.InfoAttr(), (Object)CSRF$TokenInfo$.MODULE$.apply((Function0<CSRF.Token>)(Function0 & Serializable)() -> this.generateToken()));
    }

    public RequestHeader tagRequestHeaderWithNewToken(RequestHeader request) {
        return request.addAttr(CSRF$Token$.MODULE$.InfoAttr(), (Object)CSRF$TokenInfo$.MODULE$.apply((Function0<CSRF.Token>)(Function0 & Serializable)() -> this.generateToken()));
    }

    public Http.RequestBuilder tagRequestWithNewToken(Http.RequestBuilder requestBuilder) {
        return requestBuilder.attr(new TypedKey(CSRF$Token$.MODULE$.InfoAttr()), (Object)CSRF$TokenInfo$.MODULE$.apply((Function0<CSRF.Token>)(Function0 & Serializable)() -> this.generateToken()));
    }

    public CSRF.Token generateToken() {
        return new CSRF.Token(this.csrfConfig.tokenName(), this.tokenProvider.generateToken());
    }

    public Option<String> getHeaderToken(RequestHeader request) {
        Option queryStringToken = request.getQueryString(this.csrfConfig.tokenName());
        Option headerToken = request.headers().get(this.csrfConfig.headerName());
        return queryStringToken.orElse((Function0 & Serializable)() -> headerToken);
    }

    public boolean requiresCsrfCheck(RequestHeader request) {
        if (this.csrfConfig.bypassCorsTrustedOrigins() && request.attrs().contains(CORSFilter$Attrs$.MODULE$.Origin())) {
            CSRF$.MODULE$.filterLogger().trace((Function0 & Serializable)() -> "[CSRF] Bypassing check because CORSFilter request tag found", MarkerContext$.MODULE$.NoMarker());
            return false;
        }
        return BoxesRunTime.unboxToBoolean((Object)this.csrfConfig.shouldProtect().apply((Object)request));
    }

    public Result addTokenToResponse(RequestHeader request, Result result) {
        boolean bl = false;
        Some some = null;
        Option option = request.attrs().get(CSRF$Token$.MODULE$.InfoAttr());
        if (None$.MODULE$.equals(option)) {
            CSRF$.MODULE$.filterLogger().warn((Function0 & Serializable)() -> "[CSRF] No token found on request!", MarkerContext$.MODULE$.NoMarker());
            return result;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CSRF.TokenInfo tokenInfo = (CSRF.TokenInfo)some.value();
            if (this.tokenIsHttpOnly() && result.body() instanceof HttpEntity.Strict && !tokenInfo.wasRendered()) {
                CSRF$.MODULE$.filterLogger().trace((Function0 & Serializable)() -> "[CSRF] Not emitting CSRF token because token was never rendered", MarkerContext$.MODULE$.NoMarker());
                return result;
            }
        }
        if (this.isCacheableBySharedCache(result)) {
            CSRF$.MODULE$.filterLogger().trace((Function0 & Serializable)() -> "[CSRF] Not adding token to response that might get cached by a shared cache (e.g. proxies)", MarkerContext$.MODULE$.NoMarker());
            return result;
        }
        if (bl) {
            CSRF.TokenInfo tokenInfo = (CSRF.TokenInfo)some.value();
            CSRF.Token token = tokenInfo.toToken();
            if (token == null) {
                throw new MatchError((Object)token);
            }
            String tokenName = token.name();
            String tokenValue = token.value();
            Tuple2 tuple2 = new Tuple2((Object)tokenName, (Object)tokenValue);
            String tokenName2 = (String)tuple2._1();
            String tokenValue2 = (String)tuple2._2();
            CSRF$.MODULE$.filterLogger().trace((Function0 & Serializable)() -> "[CSRF] Adding token to result: " + result, MarkerContext$.MODULE$.NoMarker());
            return (Result)this.csrfConfig.cookieName().map((Function1 & Serializable)name -> {
                Cookie[] cookieArray = new Cookie[1];
                String x$1 = name;
                String x$2 = tokenValue2;
                String x$3 = $this.sessionConfiguration.path();
                Option x$4 = $this.sessionConfiguration.domain();
                boolean x$5 = $this.csrfConfig.secureCookie();
                boolean x$6 = $this.csrfConfig.httpOnlyCookie();
                Option<Cookie.SameSite> x$7 = $this.csrfConfig.sameSiteCookie();
                Option x$8 = Cookie$.MODULE$.apply$default$3();
                cookieArray[0] = new Cookie(x$1, x$2, x$8, x$3, x$4, x$5, x$6, x$7);
                return result.withCookies((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])cookieArray));
            }).getOrElse((Function0 & Serializable)() -> {
                Session newSession = result.session(request).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tokenName2), (Object)tokenValue2));
                return result.withSession(newSession);
            });
        }
        throw new MatchError((Object)option);
    }

    private String[] extractCacheControlDirectives(String headerValue) {
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])headerValue.toLowerCase(Locale.ROOT).split(",")), (Function1 & Serializable)x$14 -> x$14.trim(), ClassTag$.MODULE$.apply(String.class));
    }

    public boolean isCacheableBySharedCache(Result result) {
        return BoxesRunTime.unboxToBoolean((Object)result.header().headers().get((Object)HeaderNames$.MODULE$.CACHE_CONTROL()).map((Function1 & Serializable)headerValue -> this.extractCacheControlDirectives((String)headerValue)).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CSRFActionHelper.$anonfun$isCacheableBySharedCache$3(this, x$15))));
    }

    public boolean isCached(Result result) {
        return this.isCacheableBySharedCache(result);
    }

    public Future<Result> clearTokenIfInvalid(RequestHeader request, CSRF.ErrorHandler errorHandler, String msg) {
        return errorHandler.handle(request.addAttr(HttpErrorHandler.Attrs$.MODULE$.HttpErrorInfo(), (Object)new HttpErrorInfo("csrf-filter")), msg).map((Function1 & Serializable)result -> (Result)CSRF$.MODULE$.getToken(request).fold((Function0 & Serializable)() -> (Result)$this.csrfConfig.cookieName().flatMap((Function1 & Serializable)cookie -> request.cookies().get(cookie).map((Function1 & Serializable)token -> {
            DiscardingCookie[] discardingCookieArray = new DiscardingCookie[1];
            String x$1 = cookie;
            Option x$2 = $this.sessionConfiguration.domain();
            String x$3 = $this.sessionConfiguration.path();
            boolean x$4 = $this.csrfConfig.secureCookie();
            Option x$5 = DiscardingCookie$.MODULE$.apply$default$5();
            discardingCookieArray[0] = new DiscardingCookie(x$1, x$3, x$2, x$4, x$5);
            return result.discardingCookies((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])discardingCookieArray));
        })).getOrElse((Function0 & Serializable)() -> result.withSession(result.session(request).$minus($this.csrfConfig.tokenName()))), (Function1 & Serializable)x$16 -> result), (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
    }

    public boolean hasInvalidContentType(RequestHeader request) {
        return request.contentType().isEmpty() && request.headers().toMap().contains((Object)HeaderNames$.MODULE$.CONTENT_TYPE());
    }

    public static final /* synthetic */ boolean $anonfun$getTokenToValidate$4(CSRFActionHelper $this, String token) {
        return !$this.csrfConfig.signTokens() || $this.tokenSigner.extractSignedToken(token).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$isCacheableBySharedCache$4(CSRFActionHelper $this, String elem) {
        return $this.NoCacheDirectives().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$isCacheableBySharedCache$3(CSRFActionHelper $this, String[] x$15) {
        return !ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])x$15), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)CSRFActionHelper.$anonfun$isCacheableBySharedCache$4($this, elem)));
    }

    public CSRFActionHelper(SessionConfiguration sessionConfiguration, CSRFConfig csrfConfig, CSRFTokenSigner tokenSigner, CSRF.TokenProvider tokenProvider) {
        this.sessionConfiguration = sessionConfiguration;
        this.csrfConfig = csrfConfig;
        this.tokenSigner = tokenSigner;
        this.tokenProvider = tokenProvider;
        this.NoCacheDirectives = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"no-cache", "no-store", "private"}));
    }

    public CSRFActionHelper(SessionConfiguration sessionConfiguration, CSRFConfig csrfConfig, CSRFTokenSigner tokenSigner) {
        this(sessionConfiguration, csrfConfig, tokenSigner, new CSRF.TokenProviderProvider(csrfConfig, tokenSigner).get());
    }
}

