/*
 * Decompiled with CFR 0.152.
 */
package play.filters.csrf;

import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import play.api.http.SessionConfiguration;
import play.api.libs.crypto.CSRFTokenSigner;
import play.api.mvc.Cookie;
import play.api.mvc.Request;
import play.api.mvc.RequestHeader;
import play.filters.csrf.AddCSRFToken;
import play.filters.csrf.CSRF;
import play.filters.csrf.CSRFActionHelper;
import play.filters.csrf.CSRFConfig;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class AddCSRFTokenAction
extends Action<AddCSRFToken> {
    private final CSRFConfig config;
    private final SessionConfiguration sessionConfiguration;
    private final CSRF.TokenProvider tokenProvider;
    private final CSRFTokenSigner tokenSigner;

    @Inject
    public AddCSRFTokenAction(CSRFConfig cSRFConfig, SessionConfiguration sessionConfiguration, CSRF.TokenProvider tokenProvider, CSRFTokenSigner cSRFTokenSigner) {
        this.config = cSRFConfig;
        this.sessionConfiguration = sessionConfiguration;
        this.tokenProvider = tokenProvider;
        this.tokenSigner = cSRFTokenSigner;
    }

    public CompletionStage<Result> call(Http.Request request) {
        CSRFActionHelper cSRFActionHelper = new CSRFActionHelper(this.sessionConfiguration, this.config, this.tokenSigner, this.tokenProvider);
        Request request2 = cSRFActionHelper.tagRequestFromHeader(request.asScala());
        if (cSRFActionHelper.getTokenToValidate((RequestHeader)request2).isEmpty()) {
            CSRF.Token token = cSRFActionHelper.generateToken();
            request2 = cSRFActionHelper.tagRequest(request2, token);
            return this.delegate.call((Http.Request)new Http.RequestImpl(request2)).thenApply(result -> this.placeToken(request, (Result)result, token));
        }
        return this.delegate.call((Http.Request)new Http.RequestImpl(request2));
    }

    private Result placeToken(Http.Request request, Result result, CSRF.Token token) {
        if (this.config.cookieName().isDefined()) {
            Option option = this.sessionConfiguration.domain();
            Http.Cookie cookie = new Http.Cookie((String)this.config.cookieName().get(), token.value(), null, this.sessionConfiguration.path(), option.isDefined() ? (String)option.get() : null, this.config.secureCookie(), this.config.httpOnlyCookie(), (Http.Cookie.SameSite)OptionConverters.toJava(this.config.sameSiteCookie()).map(Cookie.SameSite::asJava).orElse(null));
            return result.withCookies(new Http.Cookie[]{cookie});
        }
        return result.addingToSession(request, token.name(), token.value());
    }
}

