/*
 * Decompiled with CFR 0.152.
 */
package play.filters.csp;

import java.util.concurrent.CompletionStage;
import play.api.mvc.RequestHeader;
import play.api.mvc.request.RequestAttrKey;
import play.filters.csp.CSP;
import play.filters.csp.CSPProcessor;
import play.filters.csp.CSPResult;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public abstract class AbstractCSPAction
extends Action<CSP> {
    public abstract CSPProcessor processor();

    public CompletionStage<Result> call(Http.Request request) {
        Option<CSPResult> option = this.processor().process((RequestHeader)request.asScala());
        if (option.isEmpty()) {
            return this.delegate.call(request);
        }
        CSPResult cSPResult = (CSPResult)option.get();
        Http.Request request2 = OptionConverters.toJava(cSPResult.nonce()).map(string -> request.addAttr(RequestAttrKey.CSPNonce().asJava(), string)).orElseGet(() -> request);
        return this.delegate.call(request2).thenApply(result -> {
            Result result2 = result;
            if (cSPResult.nonceHeader()) {
                result2 = result2.withHeader("X-Content-Security-Policy-Nonce", (String)cSPResult.nonce().get());
            }
            return result2.withHeader("Content-Security-Policy", cSPResult.directives());
        });
    }
}

