/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.filesystem;

import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.core.Location;
import io.avaje.classpath.scanner.internal.ScanLog;
import io.avaje.classpath.scanner.internal.scanner.filesystem.FileSystemResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.slf4j.Logger;

public class FileSystemScanner {
    private static final Logger log = ScanLog.log;

    public List<Resource> scanForResources(Location location, Predicate<String> predicate) {
        String path = location.path();
        File dir = new File(path);
        if (!dir.isDirectory() || !dir.canRead()) {
            log.debug("Unable to resolve location filesystem: {}", (Object)path);
            return Collections.emptyList();
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String resourceName : this.findResourceNames(path, predicate)) {
            resources.add(new FileSystemResource(resourceName));
        }
        return resources;
    }

    private Set<String> findResourceNames(String path, Predicate<String> predicate) {
        Set<String> resourceNames = this.findResourceNamesFromFileSystem(path, new File(path));
        return this.filterResourceNames(resourceNames, predicate);
    }

    Set<String> findResourceNamesFromFileSystem(String scanRootLocation, File folder) {
        log.trace("scan path: {} ({})", (Object)folder.getPath(), (Object)scanRootLocation);
        TreeSet<String> resourceNames = new TreeSet<String>();
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.canRead()) continue;
                if (file.isDirectory()) {
                    resourceNames.addAll(this.findResourceNamesFromFileSystem(scanRootLocation, file));
                    continue;
                }
                resourceNames.add(file.getPath());
            }
        }
        return resourceNames;
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, Predicate<String> predicate) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            if (!predicate.test(resourceName)) continue;
            filteredResourceNames.add(resourceName);
        }
        return filteredResourceNames;
    }
}

