/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.filesystem;

import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.internal.FileCopyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;

class FileSystemResource
implements Resource {
    private final File file;

    FileSystemResource(String location) {
        this.file = new File(location);
    }

    public String toString() {
        return this.file.toString();
    }

    public String location() {
        return this.file.getPath().replace('\\', '/');
    }

    public String name() {
        return this.file.getName();
    }

    public InputStream inputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String loadAsString(Charset charset) {
        return FileCopyUtils.copyToString(this.inputStream(), charset);
    }

    public List<String> loadAsLines(Charset charset) {
        return FileCopyUtils.readLines(this.inputStream(), charset);
    }
}

