/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.classpath.android;

import android.content.Context;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.core.AndriodContextHolder;
import io.avaje.classpath.scanner.core.Location;
import io.avaje.classpath.scanner.internal.ResourceAndClassScanner;
import io.avaje.classpath.scanner.internal.ScanLog;
import io.avaje.classpath.scanner.internal.scanner.classpath.android.AndroidResource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;

public class AndroidScanner
implements ResourceAndClassScanner {
    private final Context context;
    private final PathClassLoader classLoader;

    public AndroidScanner(ClassLoader classLoader) {
        this.classLoader = (PathClassLoader)classLoader;
        this.context = AndriodContextHolder.getContext();
        if (this.context == null) {
            throw new IllegalStateException("Unable to create scanner. Within an activity fix this with io.avaje.classpath.scanner.android.ContextHolder.setContext(this);");
        }
    }

    @Override
    public List<Resource> scanForResources(Location location, Predicate<String> predicate) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            String path = location.path();
            for (String asset : this.context.getAssets().list(path)) {
                if (!predicate.test(asset)) continue;
                resources.add(new AndroidResource(this.context.getAssets(), path, asset));
            }
            return resources;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public List<Class<?>> scanForClasses(Location location, Predicate<Class<?>> predicate) {
        try {
            String pkg = location.path().replace("/", ".");
            ArrayList classes = new ArrayList();
            DexFile dex = new DexFile(this.context.getApplicationInfo().sourceDir);
            Enumeration entries = dex.entries();
            while (entries.hasMoreElements()) {
                Class clazz;
                String className = (String)entries.nextElement();
                if (!className.startsWith(pkg) || !predicate.test(clazz = this.classLoader.loadClass(className))) continue;
                classes.add(clazz);
                ScanLog.log.trace("found {}", (Object)className);
            }
            return classes;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

