/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type.bindcapture;

import io.ebeaninternal.server.type.bindcapture.BindCaptureEntry;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;

final class BindCaptureTypes {
    BindCaptureTypes() {
    }

    static final class BinaryStream
    implements BindCaptureEntry {
        private static final byte[] dummy = "hi".getBytes(Charset.defaultCharset());
        private final int parameterIndex;

        BinaryStream(int parameterIndex) {
            this.parameterIndex = parameterIndex;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setBinaryStream(this.parameterIndex, (InputStream)new ByteArrayInputStream(dummy), dummy.length);
        }

        public String toString() {
            return "binaryStream";
        }
    }

    static final class CharacterStream
    implements BindCaptureEntry {
        private static final String dummy = "hi";
        private final int parameterIndex;

        CharacterStream(int parameterIndex) {
            this.parameterIndex = parameterIndex;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setCharacterStream(this.parameterIndex, (Reader)new StringReader(dummy), dummy.length());
        }

        public String toString() {
            return "charStream";
        }
    }

    static final class TArray
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final String arrayType;
        private final Object[] elements;

        TArray(int parameterIndex, String arrayType, Object[] elements) {
            this.parameterIndex = parameterIndex;
            this.arrayType = arrayType;
            this.elements = elements;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            Array array = connection.createArrayOf(this.arrayType, this.elements);
            statement.setArray(this.parameterIndex, array);
        }

        public String toString() {
            return "Array{" + this.arrayType + ": " + Arrays.toString(this.elements) + "}";
        }
    }

    static final class TObject
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final Object value;

        TObject(int parameterIndex, Object value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setObject(this.parameterIndex, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class TTimestamp
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final Timestamp value;
        private final Calendar timezone;

        TTimestamp(int parameterIndex, Timestamp value, Calendar timezone) {
            this.parameterIndex = parameterIndex;
            this.value = value;
            this.timezone = timezone;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            if (this.timezone == null) {
                statement.setTimestamp(this.parameterIndex, this.value);
            } else {
                statement.setTimestamp(this.parameterIndex, this.value, this.timezone);
            }
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class TTime
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final Time value;

        TTime(int parameterIndex, Time value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setTime(this.parameterIndex, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class TDate
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final Date value;

        TDate(int parameterIndex, Date value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setDate(this.parameterIndex, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class TString
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final String value;

        TString(int parameterIndex, String value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setString(this.parameterIndex, this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    static final class TBigDecimal
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final BigDecimal value;

        TBigDecimal(int parameterIndex, BigDecimal value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setBigDecimal(this.parameterIndex, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class TDouble
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final double value;

        TDouble(int parameterIndex, double value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setDouble(this.parameterIndex, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class TFloat
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final float value;

        TFloat(int parameterIndex, float value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setFloat(this.parameterIndex, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class TLong
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final long value;

        TLong(int parameterIndex, long value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setLong(this.parameterIndex, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class TInt
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final int value;

        TInt(int parameterIndex, int value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setInt(this.parameterIndex, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class TShort
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final short value;

        TShort(int parameterIndex, short value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setShort(this.parameterIndex, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class Bytes
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final byte[] x;

        Bytes(int parameterIndex, byte[] x) {
            this.parameterIndex = parameterIndex;
            this.x = x;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setBytes(this.parameterIndex, this.x);
        }

        public String toString() {
            return Arrays.toString(this.x);
        }
    }

    static final class Byte
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final byte x;

        Byte(int parameterIndex, byte x) {
            this.parameterIndex = parameterIndex;
            this.x = x;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setByte(this.parameterIndex, this.x);
        }

        public String toString() {
            return String.valueOf(this.x);
        }
    }

    static final class Boolean
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final boolean x;

        Boolean(int parameterIndex, boolean x) {
            this.parameterIndex = parameterIndex;
            this.x = x;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setBoolean(this.parameterIndex, this.x);
        }

        public String toString() {
            return String.valueOf(this.x);
        }
    }

    static final class Null
    implements BindCaptureEntry {
        private final int parameterIndex;
        private final int sqlType;

        Null(int parameterIndex, int sqlType) {
            this.parameterIndex = parameterIndex;
            this.sqlType = sqlType;
        }

        @Override
        public void bind(PreparedStatement statement, Connection connection) throws SQLException {
            statement.setNull(this.parameterIndex, this.sqlType);
        }

        public String toString() {
            return "null";
        }
    }
}

