/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebeaninternal.server.type.IsoJsonDateTimeParser;
import io.ebeaninternal.server.type.ScalarTypeBaseDateTime;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;

final class ScalarTypeOffsetDateTime
extends ScalarTypeBaseDateTime<OffsetDateTime> {
    private final ZoneId zoneId;

    ScalarTypeOffsetDateTime(JsonConfig.DateTime mode, ZoneId zoneId) {
        super(mode, OffsetDateTime.class, false, 93);
        this.zoneId = zoneId;
    }

    @Override
    protected String toJsonNanos(OffsetDateTime value) {
        return this.toJsonNanos(value.toEpochSecond(), value.getNano());
    }

    @Override
    protected String toJsonISO8601(OffsetDateTime value) {
        return IsoJsonDateTimeParser.formatIso(value.toInstant());
    }

    @Override
    public long convertToMillis(OffsetDateTime value) {
        return value.toInstant().toEpochMilli();
    }

    @Override
    public OffsetDateTime convertFromMillis(long systemTimeMillis) {
        return this.convertFromInstant(Instant.ofEpochMilli(systemTimeMillis));
    }

    @Override
    public OffsetDateTime convertFromTimestamp(Timestamp ts) {
        return this.convertFromInstant(ts.toInstant());
    }

    @Override
    public OffsetDateTime convertFromInstant(Instant ts) {
        return OffsetDateTime.ofInstant(ts, this.zoneId);
    }

    @Override
    public Timestamp convertToTimestamp(OffsetDateTime t) {
        return Timestamp.from(t.toInstant());
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        return this.convertToTimestamp((OffsetDateTime)value);
    }

    public OffsetDateTime toBeanType(Object value) {
        if (value instanceof Timestamp) {
            return this.convertFromTimestamp((Timestamp)value);
        }
        return (OffsetDateTime)value;
    }
}

