/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.text.TextException;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeaninternal.server.type.ScalarTypeEnum;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EnumType;

final class ScalarTypeEnumStandard {
    ScalarTypeEnumStandard() {
    }

    static abstract class EnumBase
    extends ScalarTypeBase {
        protected final Class enumType;

        EnumBase(Class<?> type, boolean jdbcNative, int jdbcType) {
            super(type, jdbcNative, jdbcType);
            this.enumType = type;
        }

        @Override
        public String format(Object value) {
            return ((Enum)value).name();
        }

        public String formatValue(Object value) {
            return ((Enum)value).name();
        }

        public Object parse(String value) {
            return Enum.valueOf(this.enumType, value);
        }

        public Object convertFromMillis(long systemTimeMillis) {
            throw new TextException("Not Supported");
        }

        public boolean isDateTimeCapable() {
            return false;
        }

        public Object jsonRead(JsonParser parser) throws IOException {
            if (parser.getCodec() != null) {
                return parser.readValueAs(this.enumType);
            }
            return this.parse(parser.getValueAsString());
        }

        public void jsonWrite(JsonGenerator writer, Object value) throws IOException {
            if (writer.getCodec() != null) {
                writer.writeObject(value);
            } else {
                writer.writeString(this.formatValue(value));
            }
        }

        public DocPropertyType getDocType() {
            return DocPropertyType.ENUM;
        }

        public Object readData(DataInput dataInput) throws IOException {
            if (!dataInput.readBoolean()) {
                return null;
            }
            return this.parse(dataInput.readUTF());
        }

        public void writeData(DataOutput dataOutput, Object value) throws IOException {
            if (value == null) {
                dataOutput.writeBoolean(false);
            } else {
                ScalarHelp.writeUTF(dataOutput, this.format(value));
            }
        }
    }

    static final class OrdinalEnum
    extends EnumBase
    implements ScalarTypeEnum {
        private final Object[] enumArray;

        OrdinalEnum(Class enumType) {
            super((Class<?>)enumType, false, 4);
            this.enumArray = EnumSet.allOf(enumType).toArray();
        }

        @Override
        public boolean isCompatible(EnumType enumType) {
            return EnumType.ORDINAL == enumType;
        }

        @Override
        public Set<String> getDbCheckConstraintValues() {
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            for (Object anEnumArray : this.enumArray) {
                Enum e = (Enum)anEnumArray;
                values.add(Integer.toString(e.ordinal()));
            }
            return values;
        }

        public void bind(DataBinder binder, Object value) throws SQLException {
            if (value == null) {
                binder.setNull(4);
            } else {
                binder.setInt(((Enum)value).ordinal());
            }
        }

        public Object read(DataReader reader) throws SQLException {
            Integer ordinal = reader.getInt();
            if (ordinal == null) {
                return null;
            }
            if (ordinal < 0 || ordinal >= this.enumArray.length) {
                String m = "Unexpected ordinal [" + ordinal + "] out of range [" + this.enumArray.length + "]";
                throw new IllegalStateException(m);
            }
            return this.enumArray[ordinal];
        }

        public Object toJdbcType(Object beanValue) {
            if (beanValue == null) {
                return null;
            }
            return ((Enum)beanValue).ordinal();
        }

        public Object toBeanType(Object dbValue) {
            if (dbValue == null || dbValue instanceof Enum) {
                return dbValue;
            }
            int ordinal = dbValue instanceof Integer ? (Integer)dbValue : Integer.parseInt(dbValue.toString());
            if (ordinal < 0 || ordinal >= this.enumArray.length) {
                String m = "Unexpected ordinal [" + ordinal + "] out of range [" + this.enumArray.length + "]";
                throw new IllegalStateException(m);
            }
            return this.enumArray[ordinal];
        }
    }

    static final class StringEnum
    extends EnumBase
    implements ScalarTypeEnum {
        private final int length;

        StringEnum(Class enumType) {
            super((Class<?>)enumType, false, 12);
            this.length = this.maxValueLength(enumType);
        }

        @Override
        public boolean isCompatible(EnumType enumType) {
            return EnumType.STRING == enumType;
        }

        @Override
        public Set<String> getDbCheckConstraintValues() {
            T[] ea;
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            for (Object anEa : ea = this.enumType.getEnumConstants()) {
                Enum e = (Enum)anEa;
                values.add("'" + e.name() + "'");
            }
            return values;
        }

        private int maxValueLength(Class<?> enumType) {
            ?[] ea;
            int maxLen = 0;
            for (Object anEa : ea = enumType.getEnumConstants()) {
                Enum e = (Enum)anEa;
                maxLen = Math.max(maxLen, e.name().length());
            }
            return maxLen;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        public void bind(DataBinder binder, Object value) throws SQLException {
            if (value == null) {
                binder.setNull(12);
            } else {
                binder.setString(this.format(value));
            }
        }

        public Object read(DataReader reader) throws SQLException {
            String string = reader.getString();
            if (string == null) {
                return null;
            }
            return this.parse(string);
        }

        public Object toJdbcType(Object beanValue) {
            if (beanValue == null) {
                return null;
            }
            return this.format(beanValue);
        }

        public Object toBeanType(Object dbValue) {
            if (dbValue == null || dbValue instanceof Enum) {
                return dbValue;
            }
            return Enum.valueOf(this.enumType, (String)dbValue);
        }
    }
}

