/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.STreePropertyAssoc;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.STreeType;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.query.SqlTreeLoad;
import io.ebeaninternal.server.query.SqlTreeLoadBean;
import io.ebeaninternal.server.query.SqlTreeNode;
import io.ebeaninternal.server.query.SqlTreeProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SqlTreeNodeBean
implements SqlTreeNode {
    private static final SqlTreeLoad[] NO_LOAD_CHILDREN = new SqlTreeLoad[0];
    final STreeType desc;
    final IdBinder idBinder;
    final List<SqlTreeNode> children;
    boolean partialObject;
    STreeProperty[] properties;
    final String extraWhere;
    final STreePropertyAssoc nodeBeanProp;
    final boolean readId;
    final boolean readIdNormal;
    final boolean disableLazyLoad;
    final InheritInfo inheritInfo;
    final String prefix;
    final Map<String, String> pathMap;
    final STreePropertyAssocMany lazyLoadParent;
    final SpiQuery.TemporalMode temporalMode;
    final boolean temporalVersions;
    final IdBinder lazyLoadParentIdBinder;
    String baseTableAlias;
    boolean intersectionAsOfTableAlias;
    final boolean aggregation;

    SqlTreeNodeBean(String prefix, STreePropertyAssoc beanProp, SqlTreeProperties props, List<SqlTreeNode> myChildren, boolean withId, SpiQuery.TemporalMode temporalMode, boolean disableLazyLoad) {
        this(prefix, beanProp, beanProp.target(), props, myChildren, withId, null, temporalMode, disableLazyLoad);
    }

    SqlTreeNodeBean(STreeType desc, SqlTreeProperties props, List<SqlTreeNode> myList, boolean withId, STreePropertyAssocMany many, SpiQuery.TemporalMode temporalMode, boolean disableLazyLoad) {
        this(null, null, desc, props, myList, withId, many, temporalMode, disableLazyLoad);
    }

    private SqlTreeNodeBean(String prefix, STreePropertyAssoc beanProp, STreeType desc, SqlTreeProperties props, List<SqlTreeNode> myChildren, boolean withId, STreePropertyAssocMany lazyLoadParent, SpiQuery.TemporalMode temporalMode, boolean disableLazyLoad) {
        this.lazyLoadParent = lazyLoadParent;
        this.lazyLoadParentIdBinder = lazyLoadParent == null ? null : lazyLoadParent.idBinder();
        this.prefix = prefix;
        this.desc = desc;
        this.inheritInfo = desc.inheritInfo();
        this.idBinder = desc.idBinder();
        this.temporalMode = temporalMode;
        this.temporalVersions = temporalMode == SpiQuery.TemporalMode.VERSIONS;
        this.nodeBeanProp = beanProp;
        this.extraWhere = beanProp == null ? null : beanProp.extraWhere();
        this.aggregation = props.isAggregation();
        boolean aggregationRoot = props.isAggregationRoot();
        this.readId = !aggregationRoot && withId && desc.hasId();
        this.readIdNormal = this.readId && !this.temporalVersions;
        this.disableLazyLoad = disableLazyLoad || !this.readIdNormal || desc.isRawSqlBased();
        this.partialObject = props.isPartialObject();
        this.properties = props.getProps();
        this.children = myChildren == null ? Collections.emptyList() : myChildren;
        this.pathMap = this.createPathMap(prefix, desc);
    }

    @Override
    public SqlTreeLoad createLoad() {
        return new SqlTreeLoadBean(this);
    }

    protected SqlTreeLoad[] createLoadChildren() {
        if (this.children.isEmpty()) {
            return NO_LOAD_CHILDREN;
        }
        ArrayList<SqlTreeLoad> loadChildren = new ArrayList<SqlTreeLoad>(this.children.size());
        for (SqlTreeNode child : this.children) {
            SqlTreeLoad load = child.createLoad();
            if (load == null) continue;
            loadChildren.add(load);
        }
        return loadChildren.toArray(new SqlTreeLoad[0]);
    }

    @Override
    public final boolean isSingleProperty() {
        return this.properties != null && this.properties.length == 1 && this.children.isEmpty();
    }

    private Map<String, String> createPathMap(String prefix, STreeType desc) {
        return prefix == null ? Collections.emptyMap() : desc.pathMap(prefix);
    }

    private String path(String prefix, String propertyName) {
        return prefix == null ? propertyName : prefix + "." + propertyName;
    }

    @Override
    public final void buildRawSqlSelectChain(List<String> selectChain) {
        if (this.readId) {
            if (this.inheritInfo != null) {
                selectChain.add(this.path(this.prefix, this.inheritInfo.getDiscriminatorColumn()));
            }
            this.idBinder.buildRawSqlSelectChain(this.prefix, selectChain);
        }
        for (STreeProperty property : this.properties) {
            property.buildRawSqlSelectChain(this.prefix, selectChain);
        }
        for (SqlTreeNode child : this.children) {
            child.buildRawSqlSelectChain(selectChain);
        }
    }

    @Override
    public final void appendGroupBy(DbSqlContext ctx, boolean subQuery) {
        ctx.pushJoin(this.prefix);
        ctx.pushTableAlias(this.prefix);
        if (this.lazyLoadParent != null) {
            this.lazyLoadParent.addSelectExported(ctx, this.prefix);
        }
        if (this.readId) {
            this.appendSelectId(ctx, this.idBinder.getBeanProperty());
        }
        for (STreeProperty property : this.properties) {
            if (property.isAggregation()) continue;
            property.appendSelect(ctx, subQuery);
        }
        for (SqlTreeNode child : this.children) {
            child.appendGroupBy(ctx, subQuery);
        }
        ctx.popTableAlias();
        ctx.popJoin();
    }

    @Override
    public void appendDistinctOn(DbSqlContext ctx, boolean subQuery) {
        for (SqlTreeNode child : this.children) {
            child.appendDistinctOn(ctx, subQuery);
        }
    }

    @Override
    public final void appendSelect(DbSqlContext ctx, boolean subQuery) {
        ctx.pushJoin(this.prefix);
        ctx.pushTableAlias(this.prefix);
        if (this.temporalVersions) {
            ctx.appendHistorySysPeriod();
        }
        if (this.lazyLoadParent != null) {
            this.lazyLoadParent.addSelectExported(ctx, this.prefix);
        }
        if (this.readId) {
            if (!subQuery && this.inheritInfo != null) {
                ctx.appendColumn(this.inheritInfo.getDiscriminatorColumn());
            }
            this.appendSelectId(ctx, this.idBinder.getBeanProperty());
        }
        this.appendSelect(ctx, subQuery, this.properties);
        for (SqlTreeNode child : this.children) {
            child.appendSelect(ctx, subQuery);
        }
        ctx.popTableAlias();
        ctx.popJoin();
    }

    @Override
    public final boolean isAggregation() {
        if (this.aggregation) {
            return true;
        }
        for (SqlTreeNode child : this.children) {
            if (!child.isAggregation()) continue;
            return true;
        }
        return false;
    }

    private void appendSelect(DbSqlContext ctx, boolean subQuery, STreeProperty[] props) {
        for (STreeProperty prop : props) {
            prop.appendSelect(ctx, subQuery);
        }
    }

    final void appendSelectId(DbSqlContext ctx, STreeProperty prop) {
        if (prop != null) {
            prop.appendSelect(ctx, false);
        }
    }

    @Override
    public final void appendWhere(DbSqlContext ctx) {
        if (this.inheritInfo != null && this.nodeBeanProp == null && !this.inheritInfo.isRoot()) {
            if (ctx.length() > 0) {
                ctx.append(" and");
            }
            ctx.append(" ").append(ctx.getTableAlias(this.prefix)).append(".");
            ctx.append(this.inheritInfo.getWhere());
        }
        this.appendExtraWhere(ctx);
        for (SqlTreeNode child : this.children) {
            child.appendWhere(ctx);
        }
    }

    void appendExtraWhere(DbSqlContext ctx) {
        if (this.extraWhere != null) {
            if (ctx.length() > 0) {
                ctx.append(" and");
            }
            String ta = ctx.getTableAlias(this.prefix);
            ctx.append(" ").append(this.extraWhere.replace("${ta}", ta));
        }
    }

    @Override
    public void appendFrom(DbSqlContext ctx, SqlJoinType joinType) {
        if (this.nodeBeanProp != null && this.nodeBeanProp.isFormula()) {
            this.nodeBeanProp.appendFrom(ctx, joinType, null);
        }
        ctx.pushJoin(this.prefix);
        ctx.pushTableAlias(this.prefix);
        this.baseTableAlias = ctx.getTableAlias(this.prefix);
        joinType = this.appendFromBaseTable(ctx, joinType);
        for (STreeProperty property : this.properties) {
            property.appendFrom(ctx, joinType, null);
        }
        for (SqlTreeNode child : this.children) {
            child.appendFrom(ctx, joinType);
        }
        ctx.popTableAlias();
        ctx.popJoin();
    }

    @Override
    public final void addSoftDeletePredicate(SpiQuery<?> query) {
        if (this.desc.isSoftDelete()) {
            query.addSoftDeletePredicate(this.desc.softDeletePredicate(this.baseTableAlias));
        }
    }

    @Override
    public void addAsOfTableAlias(SpiQuery<?> query) {
        if (this.desc.isHistorySupport()) {
            query.incrementAsOfTableCount();
        }
        if (this.lazyLoadParent != null && this.lazyLoadParent.isManyToManyWithHistory()) {
            query.incrementAsOfTableCount();
        }
        if (this.intersectionAsOfTableAlias) {
            query.incrementAsOfTableCount();
        }
        for (SqlTreeNode child : this.children) {
            child.addAsOfTableAlias(query);
        }
    }

    @Override
    public void dependentTables(Set<String> tables) {
        tables.add(this.nodeBeanProp.target().baseTable(this.temporalMode));
        for (SqlTreeNode child : this.children) {
            child.dependentTables(tables);
        }
    }

    SqlJoinType appendFromBaseTable(DbSqlContext ctx, SqlJoinType joinType) {
        SqlJoinType sqlJoinType = this.appendFromAsJoin(ctx, joinType);
        if (this.inheritInfo != null) {
            this.appendJoinDiscriminator(ctx);
        }
        if (this.desc.isSoftDelete() && this.temporalMode != SpiQuery.TemporalMode.SOFT_DELETED) {
            ctx.append(" and ").append(this.desc.softDeletePredicate(ctx.getTableAlias(this.prefix)));
        }
        return sqlJoinType;
    }

    SqlJoinType appendFromAsJoin(DbSqlContext ctx, SqlJoinType joinType) {
        STreePropertyAssocMany manyProp;
        if (this.nodeBeanProp instanceof STreePropertyAssocMany && (manyProp = (STreePropertyAssocMany)this.nodeBeanProp).hasJoinTable()) {
            String alias = ctx.getTableAlias(this.prefix);
            String[] split = SplitName.split((String)this.prefix);
            String parentAlias = ctx.getTableAlias(split[0]);
            String alias2 = alias + "z_";
            TableJoin manyToManyJoin = manyProp.intersectionTableJoin();
            manyToManyJoin.addJoin(joinType, parentAlias, alias2, ctx);
            if (!manyProp.isExcludedFromHistory()) {
                this.intersectionAsOfTableAlias = true;
            }
            return this.nodeBeanProp.addJoin(joinType, alias2, alias, ctx);
        }
        return this.nodeBeanProp.addJoin(joinType, this.prefix, ctx);
    }

    void appendJoinDiscriminator(DbSqlContext ctx) {
        if (this.inheritInfo.getWhere() == null) {
            return;
        }
        String alias = ctx.getTableAlias(this.prefix);
        ctx.append(" and ").append(alias).append(".").append(this.inheritInfo.getWhere());
    }

    public String toString() {
        return "SqlTreeNodeBean: " + this.desc;
    }

    @Override
    public boolean hasMany() {
        for (SqlTreeNode child : this.children) {
            if (!child.hasMany()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unselectLobs() {
        if (this.children != null) {
            for (SqlTreeNode child : this.children) {
                child.unselectLobs();
            }
        }
        if (this.hasLob()) {
            ArrayList<STreeProperty> lst = new ArrayList<STreeProperty>();
            for (STreeProperty prop : this.properties) {
                if (prop.isDbLob()) continue;
                lst.add(prop);
            }
            this.properties = lst.toArray(new STreeProperty[0]);
            this.partialObject = true;
        }
    }

    private boolean hasLob() {
        for (STreeProperty prop : this.properties) {
            if (!prop.isDbLob()) continue;
            return true;
        }
        return false;
    }
}

