/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.CancelableQuery;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.CQueryPredicates;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.locks.ReentrantLock;

final class CQueryUpdate
implements SpiProfileTransactionEvent,
CancelableQuery {
    private final CQueryPlan queryPlan;
    private final OrmQueryRequest<?> request;
    private final BeanDescriptor<?> desc;
    private final SpiQuery<?> query;
    private final CQueryPredicates predicates;
    private final String sql;
    private PreparedStatement pstmt;
    private String bindLog;
    private int rowCount;
    private long profileOffset;
    private long executionTimeMicros;
    private final ReentrantLock lock = new ReentrantLock();

    CQueryUpdate(OrmQueryRequest<?> request, CQueryPredicates predicates, CQueryPlan queryPlan) {
        this.request = request;
        this.queryPlan = queryPlan;
        this.query = request.query();
        this.sql = queryPlan.getSql();
        this.desc = request.descriptor();
        this.predicates = predicates;
        this.query.setGeneratedSql(this.sql);
    }

    public String getBindLog() {
        return this.bindLog;
    }

    public String getGeneratedSql() {
        return this.sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws SQLException {
        long startNano = System.nanoTime();
        try {
            SpiTransaction t = this.getTransaction();
            this.profileOffset = t.profileOffset();
            Connection conn = t.getInternalConnection();
            this.lock.lock();
            try {
                this.query.checkCancelled();
                this.pstmt = conn.prepareStatement(this.sql);
                if (this.query.getTimeout() > 0) {
                    this.pstmt.setQueryTimeout(this.query.getTimeout());
                }
                this.bindLog = this.predicates.bind(this.pstmt, conn);
            }
            finally {
                this.lock.unlock();
            }
            this.rowCount = this.pstmt.executeUpdate();
            this.query.checkCancelled();
            this.executionTimeMicros = (System.nanoTime() - startNano) / 1000L;
            this.request.slowQueryCheck(this.executionTimeMicros, this.rowCount);
            if (this.queryPlan.executionTime(this.executionTimeMicros)) {
                this.queryPlan.captureBindForQueryPlan(this.predicates, this.executionTimeMicros);
            }
            t.profileEvent(this);
            int n = this.rowCount;
            return n;
        }
        finally {
            this.close();
        }
    }

    long micros() {
        return this.executionTimeMicros;
    }

    private SpiTransaction getTransaction() {
        return this.request.transaction();
    }

    private void close() {
        JdbcClose.close((Statement)this.pstmt);
        this.pstmt = null;
    }

    @Override
    public void profile() {
        this.getTransaction().profileStream().addQueryEvent(this.query.profileEventId(), this.profileOffset, this.desc.name(), this.rowCount, this.query.getProfileId());
    }

    public void cancel() {
        this.lock.lock();
        try {
            JdbcClose.cancel((Statement)this.pstmt);
        }
        finally {
            this.lock.unlock();
        }
    }
}

