/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.executor;

import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.executor.DaemonThreadFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public final class DaemonScheduleThreadPool
extends ScheduledThreadPoolExecutor {
    private static final Logger log = CoreLog.log;
    private final ReentrantLock lock = new ReentrantLock();
    private final String namePrefix;
    private final int shutdownWaitSeconds;

    public DaemonScheduleThreadPool(int coreSize, int shutdownWaitSeconds, String namePrefix) {
        super(coreSize, new DaemonThreadFactory(namePrefix));
        this.namePrefix = namePrefix;
        this.shutdownWaitSeconds = shutdownWaitSeconds;
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            if (super.isShutdown()) {
                log.debug("Already shutdown threadPool {}", (Object)this.namePrefix);
                return;
            }
            try {
                log.trace("shutting down threadPool {}", (Object)this.namePrefix);
                super.shutdown();
                if (!super.awaitTermination(this.shutdownWaitSeconds, TimeUnit.SECONDS)) {
                    log.info("Shutdown wait timeout exceeded. Terminating running threads for {}", (Object)this.namePrefix);
                    super.shutdownNow();
                }
                log.trace("shutdown complete for threadPool {}", (Object)this.namePrefix);
            }
            catch (Exception e) {
                log.error("Error during shutdown of threadPool " + this.namePrefix, (Throwable)e);
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

