/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.ScriptRunner;
import io.ebean.ddlrunner.DdlRunner;
import io.ebean.ddlrunner.ScriptTransform;
import io.ebean.util.IOUtils;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.util.UrlHelper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import javax.persistence.PersistenceException;

final class DScriptRunner
implements ScriptRunner {
    private static final String NEWLINE = "\n";
    private final SpiEbeanServer server;
    private final String platformName;

    DScriptRunner(SpiEbeanServer server) {
        this.server = server;
        this.platformName = this.server.platform().base().name();
    }

    public void run(String resourcePath) {
        this.run(resourcePath, null);
    }

    public void run(String path, Map<String, String> placeholderMap) {
        this.run(this.getClass().getResource(path), path, placeholderMap);
    }

    public void run(URL resource) {
        this.run(resource, null, null);
    }

    public void run(URL resource, Map<String, String> placeholderMap) {
        this.run(resource, null, placeholderMap);
    }

    public void run(Path file) {
        this.run(file, null);
    }

    public void run(Path file, Map<String, String> placeholderMap) {
        Objects.requireNonNull(file);
        String scriptName = file.toFile().getName();
        String content = this.fileContent(file);
        this.runScript(content, scriptName, placeholderMap, false);
    }

    private void run(URL resource, String scriptName, Map<String, String> placeholderMap) {
        Objects.requireNonNull(resource);
        if (scriptName == null) {
            scriptName = resource.getFile();
        }
        String content = this.content(resource);
        this.runScript(content, scriptName, placeholderMap, false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String fileContent(Path file) {
        try (FileInputStream inputStream = new FileInputStream(file.toFile());){
            String string;
            block13: {
                BufferedReader reader = IOUtils.newReader((InputStream)inputStream);
                try {
                    string = this.readContent(reader);
                    if (reader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((Reader)reader).close();
            }
            return string;
        }
        catch (IOException e) {
            throw new PersistenceException("Failed to read script content", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String content(URL resource) {
        Objects.requireNonNull(resource);
        try (InputStream inputStream = UrlHelper.openNoCache(resource);){
            String string;
            block14: {
                BufferedReader reader = IOUtils.newReader((InputStream)inputStream);
                try {
                    string = this.readContent(reader);
                    if (reader == null) break block14;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((Reader)reader).close();
            }
            return string;
        }
        catch (IOException e) {
            throw new PersistenceException("Failed to read script content", (Throwable)e);
        }
    }

    public void runScript(String name, String content, boolean useAutoCommit) {
        this.runScript(content, name, null, useAutoCommit);
    }

    private void runScript(String content, String scriptName, Map<String, String> placeholderMap, boolean useAutoCommit) {
        try {
            if (placeholderMap != null && !placeholderMap.isEmpty()) {
                content = ScriptTransform.build(null, placeholderMap).transform(content);
            }
            try (Connection connection = this.obtainConnection();){
                DdlRunner runner = new DdlRunner(useAutoCommit, scriptName, this.platformName);
                runner.runAll(content, connection);
                connection.commit();
                runner.runNonTransactional(connection);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to run script", (Throwable)e);
        }
    }

    private Connection obtainConnection() {
        try {
            return this.server.dataSource().getConnection();
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to obtain connection to run script", (Throwable)e);
        }
    }

    private String readContent(Reader reader) throws IOException {
        StringBuilder buf = new StringBuilder();
        try (LineNumberReader lineReader = new LineNumberReader(reader);){
            String line;
            while ((line = lineReader.readLine()) != null) {
                buf.append(line).append(NEWLINE);
            }
            String string = buf.toString();
            return string;
        }
    }
}

