/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.legacy.math.linearalgebra;

import de.businesslogics.bouncycastle.pqc.legacy.math.linearalgebra.IntUtils;
import de.businesslogics.bouncycastle.pqc.legacy.math.linearalgebra.IntegerFunctions;
import de.businesslogics.bouncycastle.pqc.legacy.math.linearalgebra.LittleEndianConversions;
import de.businesslogics.bouncycastle.util.Arrays;

public class Permutation {
    private int[] perm;

    public Permutation(byte[] byArray) {
        int n;
        if (byArray.length <= 4) {
            throw new IllegalArgumentException("invalid encoding");
        }
        int n2 = LittleEndianConversions.OS2IP(byArray, 0);
        if (byArray.length != 4 + n2 * (n = IntegerFunctions.ceilLog256(n2 - 1))) {
            throw new IllegalArgumentException("invalid encoding");
        }
        this.perm = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.perm[i] = LittleEndianConversions.OS2IP(byArray, 4 + i * n, n);
        }
        if (!this.isPermutation(this.perm)) {
            throw new IllegalArgumentException("invalid encoding");
        }
    }

    public byte[] getEncoded() {
        int n = this.perm.length;
        int n2 = IntegerFunctions.ceilLog256(n - 1);
        byte[] byArray = new byte[4 + n * n2];
        LittleEndianConversions.I2OSP(n, byArray, 0);
        for (int i = 0; i < n; ++i) {
            LittleEndianConversions.I2OSP(this.perm[i], byArray, 4 + i * n2, n2);
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Permutation)) {
            return false;
        }
        Permutation permutation = (Permutation)object;
        return IntUtils.equals(this.perm, permutation.perm);
    }

    public String toString() {
        String string = "[" + this.perm[0];
        for (int i = 1; i < this.perm.length; ++i) {
            string = string + ", " + this.perm[i];
        }
        string = string + "]";
        return string;
    }

    public int hashCode() {
        return Arrays.hashCode(this.perm);
    }

    private boolean isPermutation(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            if (nArray[i] < 0 || nArray[i] >= n || blArray[nArray[i]]) {
                return false;
            }
            blArray[nArray[i]] = true;
        }
        return true;
    }
}

